/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl;

import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.HomekitWebHandler;
import io.github.hapjava.server.impl.HomekitBridge;
import io.github.hapjava.server.impl.HomekitRoot;
import io.github.hapjava.server.impl.HomekitStandaloneAccessoryServer;
import io.github.hapjava.server.impl.HomekitUtils;
import io.github.hapjava.server.impl.http.impl.HomekitHttpServer;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.InvalidAlgorithmParameterException;
import java.util.concurrent.ExecutionException;
import javax.jmdns.JmDNS;

public class HomekitServer {
    private final HomekitHttpServer http;
    private final InetAddress localAddress;
    private final JmDNS jmdns;

    public HomekitServer(InetAddress localAddress, int port, int nThreads) throws IOException {
        this.localAddress = localAddress;
        this.jmdns = null;
        this.http = new HomekitHttpServer(localAddress, port, nThreads);
    }

    public HomekitServer(JmDNS jmdns, int port, int nThreads) throws IOException {
        this.jmdns = jmdns;
        this.localAddress = null;
        this.http = new HomekitHttpServer(jmdns.getInetAddress(), port, nThreads);
    }

    public HomekitServer(InetAddress localAddress, int port) throws IOException {
        this(localAddress, port, Runtime.getRuntime().availableProcessors());
    }

    public HomekitServer(JmDNS jmdns, int port) throws IOException {
        this(jmdns, port, Runtime.getRuntime().availableProcessors());
    }

    public HomekitServer(int port) throws IOException {
        this(InetAddress.getLocalHost(), port);
    }

    public void stop() {
        this.http.stop();
    }

    public HomekitStandaloneAccessoryServer createStandaloneAccessory(HomekitAuthInfo authInfo, HomekitAccessory accessory) throws IOException, ExecutionException, InterruptedException {
        if (this.jmdns != null) {
            return new HomekitStandaloneAccessoryServer(accessory, (HomekitWebHandler)this.http, this.jmdns, authInfo);
        }
        return new HomekitStandaloneAccessoryServer(accessory, (HomekitWebHandler)this.http, this.localAddress, authInfo);
    }

    public HomekitRoot createBridge(HomekitAuthInfo authInfo, String label, String manufacturer, String model, String serialNumber, String firmwareRevision, String hardwareRevision) throws IOException {
        HomekitRoot root = this.jmdns != null ? new HomekitRoot(label, (HomekitWebHandler)this.http, this.jmdns, authInfo) : new HomekitRoot(label, (HomekitWebHandler)this.http, this.localAddress, authInfo);
        root.addAccessory(new HomekitBridge(label, serialNumber, model, manufacturer, firmwareRevision, hardwareRevision));
        return root;
    }

    public static BigInteger generateSalt() {
        return HomekitUtils.generateSalt();
    }

    public static byte[] generateKey() throws InvalidAlgorithmParameterException {
        return HomekitUtils.generateKey();
    }

    public static String generateMac() {
        return HomekitUtils.generateMac();
    }

    public static String generatePin() {
        return HomekitUtils.generatePin();
    }
}

