/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl;

import com.nimbusds.srp6.SRP6Routines;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;

public class HomekitUtils {
    private static volatile SecureRandom secureRandom;

    public static BigInteger generateSalt() {
        return new BigInteger(SRP6Routines.generateRandomSalt((int)16));
    }

    public static byte[] generateKey() throws InvalidAlgorithmParameterException {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        byte[] seed = new byte[spec.getCurve().getField().getb() / 8];
        HomekitUtils.getSecureRandom().nextBytes(seed);
        return seed;
    }

    public static String generateMac() {
        int byte1 = (HomekitUtils.getSecureRandom().nextInt(255) + 1 | 2) & 0xFE;
        return Integer.toHexString(byte1) + ":" + Stream.generate(() -> HomekitUtils.getSecureRandom().nextInt(255) + 1).limit(5L).map(i -> Integer.toHexString(i)).collect(Collectors.joining(":"));
    }

    public static String generatePin() {
        String pin = String.format("%03d-%02d-%03d", HomekitUtils.getSecureRandom().nextInt(1000), HomekitUtils.getSecureRandom().nextInt(100), HomekitUtils.getSecureRandom().nextInt(1000));
        if (pin == "000-00-000" || pin == "111-11-111" || pin == "222-22-222" || pin == "333-33-333" || pin == "444-44-444" || pin == "555-55-555" || pin == "666-66-666" || pin == "777-77-777" || pin == "888-88-888" || pin == "999-99-999" || pin == "123-45-678" || pin == "876-54-321") {
            return HomekitUtils.generatePin();
        }
        return pin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SecureRandom getSecureRandom() {
        if (secureRandom != null) return secureRandom;
        Class<HomekitUtils> clazz = HomekitUtils.class;
        synchronized (HomekitUtils.class) {
            if (secureRandom != null) return secureRandom;
            secureRandom = new SecureRandom();
            // ** MonitorExit[var0] (shouldn't be in output)
            return secureRandom;
        }
    }
}

