/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.connections;

import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.connections.SubscriptionManager;
import io.github.hapjava.server.impl.http.HomekitClientConnection;
import io.github.hapjava.server.impl.http.HttpRequest;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.jmdns.JmdnsHomekitAdvertiser;
import io.github.hapjava.server.impl.json.AccessoryController;
import io.github.hapjava.server.impl.json.CharacteristicsController;
import io.github.hapjava.server.impl.pairing.PairVerificationManager;
import io.github.hapjava.server.impl.pairing.PairingManager;
import io.github.hapjava.server.impl.pairing.PairingUpdateController;
import io.github.hapjava.server.impl.responses.InternalServerErrorResponse;
import io.github.hapjava.server.impl.responses.NotFoundResponse;
import java.io.IOException;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpSession {
    private volatile PairingManager pairingManager;
    private volatile PairVerificationManager pairVerificationManager;
    private volatile AccessoryController accessoryController;
    private volatile CharacteristicsController characteristicsController;
    private final HomekitAuthInfo authInfo;
    private final HomekitRegistry registry;
    private final SubscriptionManager subscriptions;
    private final HomekitClientConnection connection;
    private final JmdnsHomekitAdvertiser advertiser;
    private static final Logger logger = LoggerFactory.getLogger(HttpSession.class);

    public HttpSession(HomekitAuthInfo authInfo, HomekitRegistry registry, SubscriptionManager subscriptions, HomekitClientConnection connection, JmdnsHomekitAdvertiser advertiser) {
        this.authInfo = authInfo;
        this.registry = registry;
        this.subscriptions = subscriptions;
        this.connection = connection;
        this.advertiser = advertiser;
    }

    public HttpResponse handleRequest(HttpRequest request) throws IOException {
        switch (request.getUri()) {
            case "/pair-setup": {
                return this.handlePairSetup(request);
            }
            case "/pair-verify": {
                return this.handlePairVerify(request);
            }
        }
        if (this.registry.isAllowUnauthenticatedRequests()) {
            return this.handleAuthenticatedRequest(request);
        }
        logger.warn("Unrecognized request for " + request.getUri());
        return new NotFoundResponse();
    }

    public HttpResponse handleAuthenticatedRequest(HttpRequest request) throws IOException {
        this.advertiser.setDiscoverable(false);
        try {
            switch (request.getUri()) {
                case "/accessories": {
                    return this.getAccessoryController().listing();
                }
                case "/characteristics": {
                    switch (request.getMethod()) {
                        case PUT: {
                            return this.getCharacteristicsController().put(request, this.connection);
                        }
                    }
                    logger.warn("Unrecognized method for " + request.getUri());
                    return new NotFoundResponse();
                }
                case "/pairings": {
                    return new PairingUpdateController(this.authInfo, this.advertiser).handle(request);
                }
            }
            if (request.getUri().startsWith("/characteristics?")) {
                return this.getCharacteristicsController().get(request);
            }
            logger.warn("Unrecognized request for " + request.getUri());
            return new NotFoundResponse();
        }
        catch (Exception e) {
            logger.warn("Could not handle request", (Throwable)e);
            return new InternalServerErrorResponse(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private HttpResponse handlePairSetup(HttpRequest request) {
        if (this.pairingManager == null) {
            Class<HttpSession> clazz = HttpSession.class;
            // MONITORENTER : io.github.hapjava.server.impl.connections.HttpSession.class
            if (this.pairingManager == null) {
                this.pairingManager = new PairingManager(this.authInfo, this.registry);
            }
            // MONITOREXIT : clazz
        }
        try {
            return this.pairingManager.handle(request);
        }
        catch (Exception e) {
            logger.warn("Exception encountered during pairing", (Throwable)e);
            return new InternalServerErrorResponse(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private HttpResponse handlePairVerify(HttpRequest request) {
        if (this.pairVerificationManager == null) {
            Class<HttpSession> clazz = HttpSession.class;
            // MONITORENTER : io.github.hapjava.server.impl.connections.HttpSession.class
            if (this.pairVerificationManager == null) {
                this.pairVerificationManager = new PairVerificationManager(this.authInfo, this.registry);
            }
            // MONITOREXIT : clazz
        }
        try {
            return this.pairVerificationManager.handle(request);
        }
        catch (Exception e) {
            logger.warn("Exception encountered while verifying pairing", (Throwable)e);
            return new InternalServerErrorResponse(e);
        }
    }

    private synchronized AccessoryController getAccessoryController() {
        if (this.accessoryController == null) {
            this.accessoryController = new AccessoryController(this.registry);
        }
        return this.accessoryController;
    }

    private synchronized CharacteristicsController getCharacteristicsController() {
        if (this.characteristicsController == null) {
            this.characteristicsController = new CharacteristicsController(this.registry, this.subscriptions);
        }
        return this.characteristicsController;
    }

    public static class SessionKey {
        private final InetAddress address;
        private final HomekitAccessory accessory;

        public SessionKey(InetAddress address, HomekitAccessory accessory) {
            this.address = address;
            this.accessory = accessory;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SessionKey) {
                return this.address.equals(((SessionKey)obj).address) && this.accessory.equals(((SessionKey)obj).accessory);
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.address.hashCode();
            hash = hash * 31 + this.accessory.hashCode();
            return hash;
        }
    }
}

