/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.connections;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LengthPrefixedByteArrayProcessor {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Byte firstLengthByteBuffer;
    private int targetLength = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(LengthPrefixedByteArrayProcessor.class);

    LengthPrefixedByteArrayProcessor() {
    }

    public synchronized Collection<byte[]> handle(byte[] data) {
        LinkedList<byte[]> results = new LinkedList<byte[]>();
        int pos = 0;
        LOGGER.trace("Received message of length {}. Existing buffer is {}", (Object)data.length, (Object)this.buffer.size());
        if (this.buffer.size() == 0) {
            while (data.length - pos > 18) {
                int targetLength = (data[0] & 0xFF) + (data[1] & 0xFF) * 256 + 16 + 2;
                LOGGER.trace("Attempting to read message of length {}", (Object)targetLength);
                if (data.length >= pos + targetLength) {
                    byte[] b = new byte[targetLength - 2];
                    System.arraycopy(data, pos + 2, b, 0, targetLength - 2);
                    results.add(b);
                    LOGGER.trace("Read complete message");
                    pos += targetLength;
                    continue;
                }
                LOGGER.trace("Not enough data available");
                break;
            }
        }
        if (data.length > pos) {
            LOGGER.trace("Remaining data available");
            this.step(data, pos, results);
        }
        LOGGER.trace("Returning {} results", (Object)results.size());
        return results;
    }

    private void step(byte[] data, int pos, Collection<byte[]> results) {
        int toWrite;
        LOGGER.trace("Performing step operation on buffer of length {} with pos {}", (Object)data.length, (Object)pos);
        if (this.targetLength == 0 && data.length == 1 + pos) {
            this.firstLengthByteBuffer = data[pos];
            LOGGER.trace("Received a single byte message, storing byte {} for later", (Object)this.firstLengthByteBuffer);
            return;
        }
        if (this.targetLength == 0) {
            if (this.firstLengthByteBuffer != null) {
                this.targetLength = (this.firstLengthByteBuffer & 0xFF) + (data[pos] & 0xFF) * 256 + 16;
                ++pos;
                LOGGER.trace("Received the second byte after storing the first byte. New length is {}", (Object)this.targetLength);
            } else {
                this.targetLength = (data[pos] & 0xFF) + (data[pos + 1] & 0xFF) * 256 + 16;
                pos += 2;
                LOGGER.trace("targetLength is {}", (Object)this.targetLength);
            }
        }
        if ((toWrite = this.targetLength - this.buffer.size()) <= data.length - pos) {
            LOGGER.trace("Received a complete message");
            this.buffer.write(data, pos, toWrite);
            results.add(this.buffer.toByteArray());
            this.buffer.reset();
            this.targetLength = 0;
            if (pos + toWrite < data.length) {
                this.step(data, pos + toWrite, results);
            }
        } else {
            LOGGER.trace("Storing {} bytes in buffer until we receive the complete {}", (Object)(data.length - pos), (Object)this.targetLength);
            this.buffer.write(data, pos, data.length - pos);
        }
    }
}

