/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdsaSigner {
    private final EdDSAPublicKey publicKey;
    private final EdDSAPrivateKey privateKey;

    public EdsaSigner(byte[] privateKeyBytes) {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        EdDSAPrivateKeySpec privateKeySpec = new EdDSAPrivateKeySpec(privateKeyBytes, (EdDSAParameterSpec)spec);
        EdDSAPublicKeySpec pubKeySpec = new EdDSAPublicKeySpec(privateKeySpec.getA(), (EdDSAParameterSpec)spec);
        this.publicKey = new EdDSAPublicKey(pubKeySpec);
        this.privateKey = new EdDSAPrivateKey(privateKeySpec);
    }

    public byte[] getPublicKey() {
        return this.publicKey.getAbyte();
    }

    public byte[] sign(byte[] material) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
        sgr.initSign((PrivateKey)this.privateKey);
        sgr.update(material);
        return sgr.sign();
    }
}

