/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.crypto;

import java.util.Base64;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;

public class HAPSetupCodeUtils {
    private static final String ALPHA_NUMERIC_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)ALPHA_NUMERIC_STRING.length());
            builder.append(ALPHA_NUMERIC_STRING.charAt(character));
        }
        return builder.toString();
    }

    public static String generateSetupId() {
        return HAPSetupCodeUtils.randomAlphaNumeric(4);
    }

    private static byte[] calculateHash(String input, Digest digest) {
        byte[] inputAsBytes = input.getBytes();
        byte[] retValue = new byte[digest.getDigestSize()];
        digest.update(inputAsBytes, 0, inputAsBytes.length);
        digest.doFinal(retValue, 0);
        return retValue;
    }

    public static String generateSHA512Hash(String value) {
        byte[] hash = HAPSetupCodeUtils.calculateHash(value.toUpperCase(), (Digest)new SHA512Digest());
        byte[] hashTuncate = new byte[4];
        System.arraycopy(hash, 0, hashTuncate, 0, 4);
        String hashStr = Base64.getEncoder().encodeToString(hashTuncate);
        return hashStr;
    }

    public static String getSetupURI(String pin, String setupId, int category) {
        long code = 0L | (long)category << 31 | 0L | 0x10000000L | 0L | (long)Integer.valueOf(pin).intValue();
        String payload = Long.toString(code, 36) + setupId;
        while (payload.length() < 13) {
            payload = '0' + payload;
        }
        return "X-HM://" + payload.toUpperCase();
    }
}

