/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoggingHandler.class);
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (logger.isTraceEnabled() && msg instanceof ByteBuf) {
            this.logBytes("READ", (ByteBuf)msg, ctx);
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (logger.isTraceEnabled() && msg instanceof ByteBuf) {
            this.logBytes("WRITE", (ByteBuf)msg, ctx);
        }
        super.write(ctx, msg, promise);
    }

    private void logBytes(String type, ByteBuf buf, ChannelHandlerContext ctx) throws IOException {
        if (buf.readableBytes() > 0) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(0, bytes, 0, bytes.length);
            logger.trace(String.format("%s %s [%s]:%n%s%n", type, buf, ctx.channel().remoteAddress().toString(), this.bytesToHex(bytes)));
        }
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

