/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.jmdns;

import io.github.hapjava.server.impl.crypto.HAPSetupCodeUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmdnsHomekitAdvertiser {
    private static final String SERVICE_TYPE = "_hap._tcp.local.";
    private final JmDNS jmdns;
    private boolean discoverable = true;
    private static final Logger logger = LoggerFactory.getLogger(JmdnsHomekitAdvertiser.class);
    private boolean isAdvertising = false;
    private String label;
    private String mac;
    private String setupId;
    private int port;
    private int configurationIndex;
    private ServiceInfo serviceInfo;

    public JmdnsHomekitAdvertiser(JmDNS jmdns) {
        this.jmdns = jmdns;
    }

    public JmdnsHomekitAdvertiser(InetAddress localAddress) throws UnknownHostException, IOException {
        this.jmdns = JmDNS.create((InetAddress)localAddress);
    }

    public synchronized void advertise(String label, String mac, int port, int configurationIndex, String setupId) throws Exception {
        if (this.isAdvertising) {
            throw new IllegalStateException("HomeKit advertiser is already running");
        }
        this.label = label;
        this.mac = mac;
        this.port = port;
        this.setupId = setupId;
        this.configurationIndex = configurationIndex;
        logger.trace("Advertising accessory " + label);
        this.registerService();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.trace("Stopping advertising in response to shutdown.");
            this.jmdns.unregisterAllServices();
        }));
        this.isAdvertising = true;
    }

    public synchronized void stop() {
        this.unregisterService();
    }

    public synchronized void setDiscoverable(boolean discoverable) throws IOException {
        if (this.discoverable != discoverable) {
            this.discoverable = discoverable;
            if (this.isAdvertising) {
                logger.trace("Re-creating service due to change in discoverability to " + discoverable);
                this.unregisterService();
                this.registerService();
            }
        }
    }

    public synchronized void setConfigurationIndex(int revision) throws IOException {
        if (this.configurationIndex != revision) {
            this.configurationIndex = revision;
            if (this.isAdvertising) {
                logger.trace("Re-creating service due to change in configuration index to " + revision);
                this.unregisterService();
                this.registerService();
            }
        }
    }

    private void unregisterService() {
        if (this.serviceInfo != null) {
            this.jmdns.unregisterService(this.serviceInfo);
            this.serviceInfo = null;
        }
    }

    private void registerService() throws IOException {
        logger.info("Registering _hap._tcp.local. on port " + this.port);
        if (this.serviceInfo != null) {
            throw new AssertionError((Object)"Registering an already registered service without unregistering first is not allowed");
        }
        this.serviceInfo = this.buildServiceInfo();
        this.jmdns.registerService(this.serviceInfo);
    }

    private ServiceInfo buildServiceInfo() {
        logger.trace("MAC:" + this.mac + " Setup Id:" + this.setupId);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("sf", this.discoverable ? "1" : "0");
        props.put("id", this.mac);
        props.put("md", this.label);
        props.put("sh", HAPSetupCodeUtils.generateSHA512Hash(this.setupId + this.mac));
        props.put("c#", Integer.toString(this.configurationIndex));
        props.put("s#", "1");
        props.put("ff", "0");
        props.put("ci", "1");
        return ServiceInfo.create((String)SERVICE_TYPE, (String)this.label, (int)this.port, (int)1, (int)1, props);
    }
}

