/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.json;

import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.characteristics.Characteristic;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.json.HapJsonResponse;
import io.github.hapjava.services.Service;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class AccessoryController {
    private final HomekitRegistry registry;

    public AccessoryController(HomekitRegistry registry) {
        this.registry = registry;
    }

    public HttpResponse listing() throws Exception {
        JsonArrayBuilder accessories = Json.createArrayBuilder();
        HashMap accessoryServiceFutures = new HashMap();
        for (HomekitAccessory homekitAccessory : this.registry.getAccessories()) {
            ArrayList<CompletableFuture<JsonObject>> arrayList = new ArrayList<CompletableFuture<JsonObject>>();
            Map<Integer, Service> servicesByInterfaceId = this.registry.getServices(homekitAccessory.getId());
            HashMap<Object, Integer> iidLookup = new HashMap<Object, Integer>();
            iidLookup.putAll(this.swapKeyAndValue(servicesByInterfaceId));
            iidLookup.putAll(this.swapKeyAndValue(this.registry.getCharacteristics(homekitAccessory.getId())));
            for (Service service : servicesByInterfaceId.values()) {
                arrayList.add(this.toJson(service, iidLookup));
            }
            accessoryServiceFutures.put(homekitAccessory.getId(), arrayList);
        }
        HashMap<Integer, JsonArrayBuilder> serviceArrayBuilders = new HashMap<Integer, JsonArrayBuilder>();
        for (Map.Entry entry : accessoryServiceFutures.entrySet()) {
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (CompletableFuture future : (List)entry.getValue()) {
                arr.add((JsonValue)future.join());
            }
            serviceArrayBuilders.put((Integer)entry.getKey(), arr);
        }
        for (HomekitAccessory homekitAccessory : this.registry.getAccessories()) {
            accessories.add(Json.createObjectBuilder().add("aid", homekitAccessory.getId()).add("services", (JsonArrayBuilder)serviceArrayBuilders.get(homekitAccessory.getId())));
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Json.createWriter((OutputStream)byteArrayOutputStream).write((JsonStructure)Json.createObjectBuilder().add("accessories", accessories).build());
            HapJsonResponse hapJsonResponse = new HapJsonResponse(byteArrayOutputStream.toByteArray());
            return hapJsonResponse;
        }
    }

    private CompletableFuture<JsonObject> toJson(Service service, Map<Object, Integer> iidLookup) throws Exception {
        String shortType = service.getType().replaceAll("^0*([0-9a-fA-F]+)-0000-1000-8000-0026BB765291$", "$1");
        JsonObjectBuilder builder = Json.createObjectBuilder().add("iid", iidLookup.get(service).intValue()).add("type", shortType);
        List<Characteristic> characteristics = service.getCharacteristics();
        ArrayList<CompletableFuture<JsonObject>> characteristicFutures = new ArrayList<CompletableFuture<JsonObject>>(characteristics.size());
        for (Characteristic characteristic : characteristics) {
            Integer iid = iidLookup.get(characteristic);
            characteristicFutures.add(characteristic.toJson(iid));
        }
        return CompletableFuture.allOf(characteristicFutures.toArray(new CompletableFuture[characteristicFutures.size()])).thenApply(v -> {
            JsonArrayBuilder jsonCharacteristics = Json.createArrayBuilder();
            characteristicFutures.stream().map(future -> (JsonObject)future.join()).forEach(c -> jsonCharacteristics.add((JsonValue)c));
            builder.add("characteristics", jsonCharacteristics);
            if (!service.getLinkedServices().isEmpty()) {
                JsonArrayBuilder jsonLinkedServices = Json.createArrayBuilder();
                service.getLinkedServices().stream().map(iidLookup::get).forEach(arg_0 -> ((JsonArrayBuilder)jsonLinkedServices).add(arg_0));
                builder.add("linked", jsonLinkedServices);
            }
            return builder.build();
        });
    }

    private <K, V> Map<V, K> swapKeyAndValue(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

