/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.json;

import io.github.hapjava.characteristics.EventableCharacteristic;
import io.github.hapjava.server.impl.connections.PendingNotification;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.json.EventResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class EventController {
    public HttpResponse getMessage(int accessoryId, int iid, EventableCharacteristic changed) throws Exception {
        JsonArrayBuilder characteristics = Json.createArrayBuilder();
        JsonObjectBuilder characteristicBuilder = Json.createObjectBuilder();
        characteristicBuilder.add("aid", accessoryId);
        characteristicBuilder.add("iid", iid);
        changed.supplyValue(characteristicBuilder);
        characteristics.add((JsonValue)characteristicBuilder.build());
        JsonObject data = Json.createObjectBuilder().add("characteristics", characteristics).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Json.createWriter((OutputStream)baos).write((JsonStructure)data);
            byte[] dataBytes = baos.toByteArray();
            EventResponse eventResponse = new EventResponse(dataBytes);
            return eventResponse;
        }
    }

    public HttpResponse getMessage(ArrayList<PendingNotification> notifications) throws Exception {
        JsonArrayBuilder characteristics = Json.createArrayBuilder();
        for (PendingNotification notification : notifications) {
            JsonObjectBuilder characteristicBuilder = Json.createObjectBuilder();
            characteristicBuilder.add("aid", notification.aid);
            characteristicBuilder.add("iid", notification.iid);
            notification.characteristic.supplyValue(characteristicBuilder);
            characteristics.add((JsonValue)characteristicBuilder.build());
        }
        JsonObject data = Json.createObjectBuilder().add("characteristics", characteristics).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Json.createWriter((OutputStream)baos).write((JsonStructure)data);
            byte[] dataBytes = baos.toByteArray();
            EventResponse eventResponse = new EventResponse(dataBytes);
            return eventResponse;
        }
    }
}

