/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.pairing;

import djb.Curve25519;
import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.crypto.ChachaDecoder;
import io.github.hapjava.server.impl.crypto.ChachaEncoder;
import io.github.hapjava.server.impl.crypto.EdsaSigner;
import io.github.hapjava.server.impl.crypto.EdsaVerifier;
import io.github.hapjava.server.impl.http.HttpRequest;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.pairing.ByteUtils;
import io.github.hapjava.server.impl.pairing.MessageType;
import io.github.hapjava.server.impl.pairing.PairVerificationRequest;
import io.github.hapjava.server.impl.pairing.PairingResponse;
import io.github.hapjava.server.impl.pairing.TypeLengthValueUtils;
import io.github.hapjava.server.impl.pairing.UpgradeResponse;
import io.github.hapjava.server.impl.responses.NotFoundResponse;
import io.github.hapjava.server.impl.responses.OkResponse;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairVerificationManager {
    private static final Logger logger = LoggerFactory.getLogger(PairVerificationManager.class);
    private static volatile SecureRandom secureRandom;
    private final HomekitAuthInfo authInfo;
    private final HomekitRegistry registry;
    private byte[] hkdfKey;
    private byte[] clientPublicKey;
    private byte[] publicKey;
    private byte[] sharedSecret;

    public PairVerificationManager(HomekitAuthInfo authInfo, HomekitRegistry registry) {
        this.authInfo = authInfo;
        this.registry = registry;
    }

    public HttpResponse handle(HttpRequest rawRequest) throws Exception {
        PairVerificationRequest request = PairVerificationRequest.of(rawRequest.getBody());
        switch (request.getStage()) {
            case ONE: {
                return this.stage1((PairVerificationRequest.Stage1Request)request);
            }
            case TWO: {
                return this.stage2((PairVerificationRequest.Stage2Request)request);
            }
        }
        return new NotFoundResponse();
    }

    private HttpResponse stage1(PairVerificationRequest.Stage1Request request) throws Exception {
        logger.trace("Starting pair verification for " + this.registry.getLabel());
        this.clientPublicKey = request.getClientPublicKey();
        this.publicKey = new byte[32];
        byte[] privateKey = new byte[32];
        PairVerificationManager.getSecureRandom().nextBytes(privateKey);
        Curve25519.keygen((byte[])this.publicKey, null, (byte[])privateKey);
        this.sharedSecret = new byte[32];
        Curve25519.curve((byte[])this.sharedSecret, (byte[])privateKey, (byte[])this.clientPublicKey);
        byte[] material = ByteUtils.joinBytes(this.publicKey, this.authInfo.getMac().getBytes(StandardCharsets.UTF_8), this.clientPublicKey);
        byte[] proof = new EdsaSigner(this.authInfo.getPrivateKey()).sign(material);
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA512Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(this.sharedSecret, "Pair-Verify-Encrypt-Salt".getBytes(StandardCharsets.UTF_8), "Pair-Verify-Encrypt-Info".getBytes(StandardCharsets.UTF_8)));
        this.hkdfKey = new byte[32];
        hkdf.generateBytes(this.hkdfKey, 0, 32);
        TypeLengthValueUtils.Encoder encoder = TypeLengthValueUtils.getEncoder();
        encoder.add(MessageType.USERNAME, this.authInfo.getMac().getBytes(StandardCharsets.UTF_8));
        encoder.add(MessageType.SIGNATURE, proof);
        byte[] plaintext = encoder.toByteArray();
        ChachaEncoder chacha = new ChachaEncoder(this.hkdfKey, "PV-Msg02".getBytes(StandardCharsets.UTF_8));
        byte[] ciphertext = chacha.encodeCiphertext(plaintext);
        encoder = TypeLengthValueUtils.getEncoder();
        encoder.add(MessageType.STATE, (short)2);
        encoder.add(MessageType.ENCRYPTED_DATA, ciphertext);
        encoder.add(MessageType.PUBLIC_KEY, this.publicKey);
        return new PairingResponse(encoder.toByteArray());
    }

    private HttpResponse stage2(PairVerificationRequest.Stage2Request request) throws Exception {
        ChachaDecoder chacha = new ChachaDecoder(this.hkdfKey, "PV-Msg03".getBytes(StandardCharsets.UTF_8));
        byte[] plaintext = chacha.decodeCiphertext(request.getAuthTagData(), request.getMessageData());
        TypeLengthValueUtils.DecodeResult d = TypeLengthValueUtils.decode(plaintext);
        byte[] clientUsername = d.getBytes(MessageType.USERNAME);
        byte[] clientSignature = d.getBytes(MessageType.SIGNATURE);
        byte[] material = ByteUtils.joinBytes(this.clientPublicKey, clientUsername, this.publicKey);
        byte[] clientLtpk = this.authInfo.getUserPublicKey(this.authInfo.getMac() + new String(clientUsername, StandardCharsets.UTF_8));
        if (clientLtpk == null) {
            throw new Exception("Unknown user: " + new String(clientUsername, StandardCharsets.UTF_8));
        }
        TypeLengthValueUtils.Encoder encoder = TypeLengthValueUtils.getEncoder();
        if (new EdsaVerifier(clientLtpk).verify(material, clientSignature)) {
            encoder.add(MessageType.STATE, (short)4);
            logger.trace("Completed pair verification for " + this.registry.getLabel());
            return new UpgradeResponse(encoder.toByteArray(), this.createKey("Control-Write-Encryption-Key"), this.createKey("Control-Read-Encryption-Key"));
        }
        encoder.add(MessageType.ERROR, (short)4);
        logger.warn("Invalid signature. Could not pair " + this.registry.getLabel());
        return new OkResponse(encoder.toByteArray());
    }

    private byte[] createKey(String info) {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA512Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(this.sharedSecret, "Control-Salt".getBytes(StandardCharsets.UTF_8), info.getBytes(StandardCharsets.UTF_8)));
        byte[] key = new byte[32];
        hkdf.generateBytes(key, 0, 32);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SecureRandom getSecureRandom() {
        if (secureRandom != null) return secureRandom;
        Class<PairVerificationManager> clazz = PairVerificationManager.class;
        synchronized (PairVerificationManager.class) {
            if (secureRandom != null) return secureRandom;
            secureRandom = new SecureRandom();
            // ** MonitorExit[var0] (shouldn't be in output)
            return secureRandom;
        }
    }
}

