/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.pairing;

import io.github.hapjava.server.impl.pairing.MessageType;
import io.github.hapjava.server.impl.pairing.Stage;
import io.github.hapjava.server.impl.pairing.TypeLengthValueUtils;

abstract class PairVerificationRequest {
    private static final short VALUE_STAGE_1 = 1;
    private static final short VALUE_STAGE_2 = 3;

    PairVerificationRequest() {
    }

    static PairVerificationRequest of(byte[] content) throws Exception {
        TypeLengthValueUtils.DecodeResult d = TypeLengthValueUtils.decode(content);
        short stage = d.getByte(MessageType.STATE);
        switch (stage) {
            case 1: {
                return new Stage1Request(d);
            }
            case 3: {
                return new Stage2Request(d);
            }
        }
        throw new Exception("Unknown pair process stage: " + stage);
    }

    abstract Stage getStage();

    static class Stage2Request
    extends PairVerificationRequest {
        private final byte[] messageData;
        private final byte[] authTagData;

        public Stage2Request(TypeLengthValueUtils.DecodeResult d) {
            this.messageData = new byte[d.getLength(MessageType.ENCRYPTED_DATA) - 16];
            this.authTagData = new byte[16];
            d.getBytes(MessageType.ENCRYPTED_DATA, this.messageData, 0);
            d.getBytes(MessageType.ENCRYPTED_DATA, this.authTagData, this.messageData.length);
        }

        public byte[] getMessageData() {
            return this.messageData;
        }

        public byte[] getAuthTagData() {
            return this.authTagData;
        }

        @Override
        public Stage getStage() {
            return Stage.TWO;
        }
    }

    static class Stage1Request
    extends PairVerificationRequest {
        private final byte[] clientPublicKey;

        public Stage1Request(TypeLengthValueUtils.DecodeResult d) {
            this.clientPublicKey = d.getBytes(MessageType.PUBLIC_KEY);
        }

        public byte[] getClientPublicKey() {
            return this.clientPublicKey;
        }

        @Override
        Stage getStage() {
            return Stage.ONE;
        }
    }
}

