/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.pairing;

import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.http.HttpRequest;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.jmdns.JmdnsHomekitAdvertiser;
import io.github.hapjava.server.impl.pairing.MessageType;
import io.github.hapjava.server.impl.pairing.PairingResponse;
import io.github.hapjava.server.impl.pairing.TypeLengthValueUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class PairingUpdateController {
    private final HomekitAuthInfo authInfo;
    private final JmdnsHomekitAdvertiser advertiser;

    public PairingUpdateController(HomekitAuthInfo authInfo, JmdnsHomekitAdvertiser advertiser) {
        this.authInfo = authInfo;
        this.advertiser = advertiser;
    }

    public HttpResponse handle(HttpRequest request) throws IOException {
        TypeLengthValueUtils.DecodeResult d = TypeLengthValueUtils.decode(request.getBody());
        byte method = d.getByte(MessageType.METHOD);
        if (method == 3) {
            byte[] username = d.getBytes(MessageType.USERNAME);
            byte[] ltpk = d.getBytes(MessageType.PUBLIC_KEY);
            this.authInfo.createUser(this.authInfo.getMac() + new String(username, StandardCharsets.UTF_8), ltpk);
        } else if (method == 4) {
            byte[] username = d.getBytes(MessageType.USERNAME);
            this.authInfo.removeUser(this.authInfo.getMac() + new String(username, StandardCharsets.UTF_8));
            if (!this.authInfo.hasUser()) {
                this.advertiser.setDiscoverable(true);
            }
        } else {
            throw new RuntimeException("Unrecognized method: " + method);
        }
        return new PairingResponse(new byte[]{6, 1, 2});
    }
}

