/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.pairing;

import io.github.hapjava.server.impl.pairing.ByteUtils;
import io.github.hapjava.server.impl.pairing.MessageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class TypeLengthValueUtils {
    private TypeLengthValueUtils() {
    }

    public static DecodeResult decode(byte[] content) throws IOException {
        DecodeResult ret = new DecodeResult();
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        while (bais.available() > 0) {
            byte type = (byte)(bais.read() & 0xFF);
            int length = bais.read();
            byte[] part = new byte[length];
            bais.read(part);
            ret.add(type, part);
        }
        return ret;
    }

    public static Encoder getEncoder() {
        return new Encoder();
    }

    public static final class DecodeResult {
        private final Map<Short, byte[]> result = new HashMap<Short, byte[]>();

        private DecodeResult() {
        }

        public byte getByte(MessageType type) {
            return this.result.get(type.getKey())[0];
        }

        public BigInteger getBigInt(MessageType type) {
            return new BigInteger(1, this.result.get(type.getKey()));
        }

        public byte[] getBytes(MessageType type) {
            return this.result.get(type.getKey());
        }

        public void getBytes(MessageType type, byte[] dest, int srcOffset) {
            byte[] b = this.result.get(type.getKey());
            System.arraycopy(b, srcOffset, dest, 0, Math.min(dest.length, b.length));
        }

        public int getLength(MessageType type) {
            return this.result.get(type.getKey()).length;
        }

        private void add(short type, byte[] bytes) {
            this.result.merge(type, bytes, (xva$0, xva$1) -> ByteUtils.joinBytes(xva$0, xva$1));
        }
    }

    public static final class Encoder {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private Encoder() {
        }

        public void add(MessageType type, BigInteger i) throws IOException {
            this.add(type, ByteUtils.toByteArray(i));
        }

        public void add(MessageType type, short b) {
            this.baos.write(type.getKey());
            this.baos.write(1);
            this.baos.write(b);
        }

        public void add(MessageType type, byte[] bytes) throws IOException {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            while (((InputStream)bais).available() > 0) {
                int toWrite = ((InputStream)bais).available();
                toWrite = toWrite > 255 ? 255 : toWrite;
                this.baos.write(type.getKey());
                this.baos.write(toWrite);
                ByteUtils.copyStream(bais, this.baos, toWrite);
            }
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

