/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.services.impl;

import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithAccessoryFlags;
import io.github.hapjava.accessories.optionalcharacteristic.AccessoryWithHardwareRevision;
import io.github.hapjava.characteristics.impl.accessoryinformation.AccessoryFlagsCharacteristic;
import io.github.hapjava.characteristics.impl.accessoryinformation.FirmwareRevisionCharacteristic;
import io.github.hapjava.characteristics.impl.accessoryinformation.HardwareRevisionCharacteristic;
import io.github.hapjava.characteristics.impl.accessoryinformation.IdentifyCharacteristic;
import io.github.hapjava.characteristics.impl.accessoryinformation.ManufacturerCharacteristic;
import io.github.hapjava.characteristics.impl.accessoryinformation.ModelCharacteristic;
import io.github.hapjava.characteristics.impl.accessoryinformation.SerialNumberCharacteristic;
import io.github.hapjava.characteristics.impl.common.NameCharacteristic;
import io.github.hapjava.services.impl.AbstractServiceImpl;

public class AccessoryInformationService
extends AbstractServiceImpl {
    public AccessoryInformationService(IdentifyCharacteristic identify, ManufacturerCharacteristic manufacturer, ModelCharacteristic model, NameCharacteristic name, SerialNumberCharacteristic serialNumber, FirmwareRevisionCharacteristic firmwareRevision) {
        super("0000003E-0000-1000-8000-0026BB765291");
        this.addCharacteristic(identify);
        this.addCharacteristic(manufacturer);
        this.addCharacteristic(model);
        this.addCharacteristic(name);
        this.addCharacteristic(serialNumber);
        this.addCharacteristic(firmwareRevision);
    }

    public AccessoryInformationService(HomekitAccessory accessory) {
        this(new IdentifyCharacteristic(value -> {
            if (value.booleanValue()) {
                accessory.identify();
            }
        }), new ManufacturerCharacteristic(accessory::getManufacturer), new ModelCharacteristic(accessory::getModel), new NameCharacteristic(accessory::getName), new SerialNumberCharacteristic(accessory::getSerialNumber), new FirmwareRevisionCharacteristic(accessory::getFirmwareRevision));
        if (accessory instanceof AccessoryWithHardwareRevision) {
            this.addOptionalCharacteristic(new HardwareRevisionCharacteristic(((AccessoryWithHardwareRevision)((Object)accessory))::getHardwareRevision));
        }
        if (accessory instanceof AccessoryWithAccessoryFlags) {
            this.addOptionalCharacteristic(new AccessoryFlagsCharacteristic(((AccessoryWithAccessoryFlags)((Object)accessory))::getAccessoryFlags, ((AccessoryWithAccessoryFlags)((Object)accessory))::subscribeAccessoryFlags, ((AccessoryWithAccessoryFlags)((Object)accessory))::unsubscribeAccessoryFlags));
        }
    }

    public void addOptionalCharacteristic(HardwareRevisionCharacteristic hardwareRevision) {
        this.addCharacteristic(hardwareRevision);
    }

    public void addOptionalCharacteristic(AccessoryFlagsCharacteristic accessoryFlagsCharacteristic) {
        this.addCharacteristic(accessoryFlagsCharacteristic);
    }
}

