/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.HeaderProvider;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ApiLoaderConfig {
    private final String baseUrl;
    private final Map<String, String> staticHeaders;
    private final HeaderProvider dynamicHeaderProvider;
    private final Duration timeout;
    private final int maxRetries;
    private final Duration retryDelay;
    private final boolean enableCaching;
    private final Duration cacheTtl;
    private final long cacheMaxSize;
    private final long cacheMaxMemoryMb;
    private final CacheEvictionPolicy cacheEvictionPolicy;

    private ApiLoaderConfig(Builder builder) {
        this.baseUrl = builder.baseUrl.endsWith("/") ? builder.baseUrl.substring(0, builder.baseUrl.length() - 1) : builder.baseUrl;
        this.staticHeaders = Collections.unmodifiableMap(new HashMap<String, String>(builder.staticHeaders));
        this.dynamicHeaderProvider = builder.dynamicHeaderProvider;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
        this.retryDelay = builder.retryDelay;
        this.enableCaching = builder.enableCaching;
        this.cacheTtl = builder.cacheTtl;
        this.cacheMaxSize = builder.cacheMaxSize;
        this.cacheMaxMemoryMb = builder.cacheMaxMemoryMb;
        this.cacheEvictionPolicy = builder.cacheEvictionPolicy;
    }

    public static Builder builder(String baseUrl) {
        return new Builder(baseUrl);
    }

    public Map<String, String> getAllHeaders() {
        Map<String, String> dynamicHeaders;
        HashMap<String, String> allHeaders = new HashMap<String, String>(this.staticHeaders);
        if (this.dynamicHeaderProvider != null && (dynamicHeaders = this.dynamicHeaderProvider.getHeaders()) != null) {
            allHeaders.putAll(dynamicHeaders);
        }
        return allHeaders;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> getStaticHeaders() {
        return this.staticHeaders;
    }

    public HeaderProvider getDynamicHeaderProvider() {
        return this.dynamicHeaderProvider;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public boolean isEnableCaching() {
        return this.enableCaching;
    }

    public Duration getCacheTtl() {
        return this.cacheTtl;
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public long getCacheMaxMemoryMb() {
        return this.cacheMaxMemoryMb;
    }

    public CacheEvictionPolicy getCacheEvictionPolicy() {
        return this.cacheEvictionPolicy;
    }

    public static class Builder {
        private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
        private static final int DEFAULT_MAX_RETRIES = 3;
        private static final Duration DEFAULT_RETRY_DELAY = Duration.ofSeconds(1L);
        private static final boolean DEFAULT_CACHING = true;
        private static final Duration DEFAULT_CACHE_TTL = Duration.ofMinutes(5L);
        private static final long DEFAULT_CACHE_MAX_SIZE = 10000L;
        private static final long DEFAULT_CACHE_MAX_MEMORY_MB = 100L;
        private static final CacheEvictionPolicy DEFAULT_CACHE_EVICTION_POLICY = CacheEvictionPolicy.LRU;
        private final String baseUrl;
        private final Map<String, String> staticHeaders = new HashMap<String, String>();
        private HeaderProvider dynamicHeaderProvider;
        private Duration timeout = DEFAULT_TIMEOUT;
        private int maxRetries = 3;
        private Duration retryDelay = DEFAULT_RETRY_DELAY;
        private boolean enableCaching = true;
        private Duration cacheTtl = DEFAULT_CACHE_TTL;
        private long cacheMaxSize = 10000L;
        private long cacheMaxMemoryMb = 100L;
        private CacheEvictionPolicy cacheEvictionPolicy = DEFAULT_CACHE_EVICTION_POLICY;

        private Builder(String baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl cannot be null");
            String trimmed = baseUrl.trim();
            if (trimmed.isEmpty()) {
                throw new IllegalArgumentException("baseUrl cannot be empty");
            }
            if (!trimmed.startsWith("http://") && !trimmed.startsWith("https://")) {
                throw new IllegalArgumentException("baseUrl must start with http:// or https://");
            }
            this.baseUrl = trimmed.endsWith("/") ? trimmed.substring(0, trimmed.length() - 1) : trimmed;
        }

        public Builder header(String name, String value) {
            Objects.requireNonNull(name, "header name cannot be null");
            Objects.requireNonNull(value, "header value cannot be null");
            this.staticHeaders.put(name, value);
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            if (headers != null) {
                this.staticHeaders.putAll(headers);
            }
            return this;
        }

        public Builder bearerToken(String token) {
            Objects.requireNonNull(token, "token cannot be null");
            return this.header("Authorization", "Bearer " + token);
        }

        public Builder basicAuth(String username, String password) {
            Objects.requireNonNull(username, "username cannot be null");
            Objects.requireNonNull(password, "password cannot be null");
            String credentials = username + ":" + password;
            String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            return this.header("Authorization", "Basic " + encoded);
        }

        public Builder headerProvider(HeaderProvider provider) {
            this.dynamicHeaderProvider = provider;
            return this;
        }

        public Builder timeout(Duration timeout) {
            Objects.requireNonNull(timeout, "timeout cannot be null");
            this.timeout = timeout;
            return this;
        }

        public Builder maxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries cannot be negative");
            }
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder retryDelay(Duration retryDelay) {
            Objects.requireNonNull(retryDelay, "retryDelay cannot be null");
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder caching(boolean enable) {
            this.enableCaching = enable;
            return this;
        }

        public Builder cacheTtl(Duration ttl) {
            Objects.requireNonNull(ttl, "cacheTtl cannot be null");
            if (ttl.isNegative() || ttl.isZero()) {
                throw new IllegalArgumentException("cacheTtl must be positive");
            }
            this.cacheTtl = ttl;
            return this;
        }

        public Builder cacheMaxSize(long maxSize) {
            if (maxSize <= 0L) {
                throw new IllegalArgumentException("cacheMaxSize must be positive");
            }
            this.cacheMaxSize = maxSize;
            return this;
        }

        public Builder cacheMaxMemoryMb(long maxMemoryMb) {
            if (maxMemoryMb <= 0L) {
                throw new IllegalArgumentException("cacheMaxMemoryMb must be positive");
            }
            this.cacheMaxMemoryMb = maxMemoryMb;
            return this;
        }

        public Builder cacheEvictionPolicy(CacheEvictionPolicy policy) {
            Objects.requireNonNull(policy, "cacheEvictionPolicy cannot be null");
            this.cacheEvictionPolicy = policy;
            return this;
        }

        public ApiLoaderConfig build() {
            if (this.maxRetries > 0 && (this.retryDelay == null || this.retryDelay.isZero() || this.retryDelay.isNegative())) {
                throw new IllegalArgumentException("retryDelay must be positive when maxRetries > 0");
            }
            return new ApiLoaderConfig(this);
        }
    }

    public static enum CacheEvictionPolicy {
        LRU,
        LFU,
        SIZE_BASED;

    }
}

