/*
 * Decompiled with CFR 0.152.
 */
package io.github.lambig.textescape;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class TextEscape {
    private static final Pattern escapePattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Pattern unescapedPattern = Pattern.compile("(?<!\\\\)\\$\\{([^}]*)\\}");
    private final List<String> texts;
    private final Map<String, String> variables = new HashMap<String, String>();
    private String defaultValue;
    private String delimiter = System.lineSeparator();

    public static TextEscape escape(String ... texts) {
        return new TextEscape(List.of(texts));
    }

    public TextEscape where(@NonNull String key, @NonNull Object value) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(value, "value is marked non-null but is null");
        String stringValue = String.valueOf(value);
        if (unescapedPattern.matcher(stringValue).find()) {
            throw new IllegalArgumentException("\u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u3066\u3044\u306a\u3044\u7f6e\u63db\u5bfe\u8c61\u6587\u5b57\u5217\u304c\u7f6e\u63db\u5f8c\u306e\u5024\u3068\u3057\u3066\u6e21\u3055\u308c\u307e\u3057\u305f: " + stringValue);
        }
        this.variables.put(key, String.valueOf(value));
        return this;
    }

    public TextEscape where(@NonNull Map<String, Object> values) {
        Objects.requireNonNull(values, "values is marked non-null but is null");
        values.forEach(this::where);
        return this;
    }

    public TextEscape setDefaultValue(String defaultValue) {
        if (unescapedPattern.matcher(defaultValue).find()) {
            throw new IllegalArgumentException("\u30a8\u30b9\u30b1\u30fc\u30d7\u3055\u308c\u3066\u3044\u306a\u3044\u7f6e\u63db\u5bfe\u8c61\u6587\u5b57\u5217\u304c\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u3068\u3057\u3066\u6e21\u3055\u308c\u307e\u3057\u305f: " + defaultValue);
        }
        this.defaultValue = defaultValue;
        return this;
    }

    public String compile() {
        String text = this.texts.stream().collect(Collectors.joining(this.delimiter));
        Set<String> keysInText = this.extractKeysFromText(text);
        Set missingKeys = keysInText.stream().filter(key -> !this.variables.containsKey(key)).collect(Collectors.toSet());
        Optional.ofNullable(this.defaultValue).ifPresentOrElse(replacement -> missingKeys.forEach(key -> this.variables.put((String)key, (String)replacement)), () -> {
            if (!missingKeys.isEmpty()) {
                throw new NoSuchElementException("\u6b21\u306e\u30ad\u30fc\u304c\u5909\u6570\u30de\u30c3\u30d7\u306b\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f: " + String.join((CharSequence)", ", missingKeys));
            }
        });
        return keysInText.stream().reduce(text, (soFar, current) -> soFar.replaceAll("(?<!\\\\)\\$\\{" + current + "\\}", this.variables.get(current))).replaceAll("\\\\\\$\\{", "\\${");
    }

    public String toString() {
        return this.compile();
    }

    private Set<String> extractKeysFromText(String text) {
        return escapePattern.matcher(text).results().map(MatchResult::group).map(group -> group.substring(2, group.length() - 1)).collect(Collectors.toSet());
    }

    @Generated
    private TextEscape(List<String> texts) {
        this.texts = texts;
    }

    @Generated
    private TextEscape(List<String> texts, String defaultValue, String delimiter) {
        this.texts = texts;
        this.defaultValue = defaultValue;
        this.delimiter = delimiter;
    }

    @Generated
    public TextEscape setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }
}

