/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.service;

import io.github.md2java.lock.annotation.ClusterLock;
import io.github.md2java.lock.model.LockInfo;
import io.github.md2java.lock.service.LockService;
import io.github.md2java.lock.util.AnnotationUtil;
import io.github.md2java.lock.util.MemoryUtil;
import io.github.md2java.lock.util.NodeUtil;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LockServiceImpl
implements LockService {
    private static final Logger log = LoggerFactory.getLogger(LockServiceImpl.class);

    @Override
    public Object applyLogic(ProceedingJoinPoint pjp) {
        Object ret = null;
        ClusterLock clusterLock = AnnotationUtil.annotatedObject(pjp, ClusterLock.class);
        LockInfo lockInfo = MemoryUtil.getLockInfo(clusterLock.name());
        if (Objects.isNull(lockInfo)) {
            try {
                TimeUnit.SECONDS.sleep(3L);
                lockInfo = MemoryUtil.getLockInfo(clusterLock.name());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isActiveNodeSame(lockInfo)) {
            try {
                ret = pjp.proceed(pjp.getArgs());
                lockInfo.setLastrun(new Date());
            }
            catch (Throwable e) {
                log.error("something went wrong: {} ", (Object)e.toString());
            }
        }
        return ret;
    }

    private boolean isActiveNodeSame(LockInfo lockInfo) {
        return StringUtils.equalsIgnoreCase((CharSequence)NodeUtil.hostId(), (CharSequence)lockInfo.getActiveNode());
    }
}

