/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.util;

import io.github.md2java.lock.annotation.ClusterLock;
import io.github.md2java.lock.annotation.EnableClusterLock;
import io.github.md2java.lock.model.LockInfo;
import io.github.md2java.lock.util.MemoryUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BeanScannerUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanScannerUtil.class);
    private final ApplicationContext applicationContext;
    private static Map<String, ClusterLock> configuredLocks;
    private static EnableClusterLock enableClusterLock;

    public void init() {
        enableClusterLock = this.findEnableClusterLock();
        configuredLocks = this.findAllClusterLock();
        log.debug("configuredLocks: {} ", BeanScannerUtil.configuredLocks());
    }

    private EnableClusterLock findEnableClusterLock() {
        Set values = this.applicationContext.getBeansWithAnnotation(EnableClusterLock.class).keySet();
        Optional findFirst = values.stream().findFirst();
        if (findFirst.isPresent()) {
            Class<?> class1 = this.applicationContext.getBean((String)findFirst.get()).getClass();
            EnableClusterLock extractCustomAnnotation = BeanScannerUtil.extractCustomAnnotation(class1, EnableClusterLock.class);
            MemoryUtil.setEnableClusterLock(extractCustomAnnotation);
            return extractCustomAnnotation;
        }
        return null;
    }

    public Map<String, ClusterLock> findAllClusterLock() {
        String[] beanNames;
        ConcurrentHashMap<String, ClusterLock> ret = new ConcurrentHashMap<String, ClusterLock>();
        for (String beanName : beanNames = this.applicationContext.getBeanDefinitionNames()) {
            Object bean = this.applicationContext.getBean(beanName);
            Class<?> beanClass = bean.getClass();
            if (StringUtils.contains((CharSequence)String.valueOf(beanClass), (CharSequence)"$")) {
                beanClass = beanClass.getSuperclass();
            }
            for (Method method : beanClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(ClusterLock.class)) continue;
                ClusterLock clusterLock = method.getAnnotation(ClusterLock.class);
                if (ret.containsKey(clusterLock.name()) || this.isMonitorSpanLess(clusterLock)) {
                    String messageTemplate = "duplicate Lockname: {} found or isMonitorSpanLess please correct and retry => {}";
                    log.warn(messageTemplate, (Object)clusterLock.name(), (Object)clusterLock);
                    throw new RuntimeException("duplicate Lockname found error");
                }
                ret.put(clusterLock.name(), clusterLock);
                LockInfo info = LockInfo.builder().clusterLock(clusterLock).lockname(clusterLock.name()).build();
                MemoryUtil.updateLockInfo(clusterLock.name(), info);
            }
        }
        return ret;
    }

    private boolean isMonitorSpanLess(ClusterLock clusterLock) {
        return enableClusterLock.monitorAt() < enableClusterLock.updateAt() + 6000L;
    }

    public static Map<String, ClusterLock> configuredLocks() {
        return configuredLocks;
    }

    public static EnableClusterLock enableClusterLock() {
        return enableClusterLock;
    }

    public static <T extends Annotation> T extractCustomAnnotation(Class<?> clazz, Class<T> annotationType) {
        T annotation = clazz.getAnnotation(annotationType);
        if (annotation == null) {
            for (Class<?> superclass = clazz.getSuperclass(); superclass != null && annotation == null; superclass = superclass.getSuperclass()) {
                annotation = superclass.getAnnotation(annotationType);
            }
        }
        return annotation;
    }

    public BeanScannerUtil(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

