/*
 * Decompiled with CFR 0.152.
 */
package io.github.moacirrf.javadecompiler;

import com.machinezoo.noexception.Exceptions;
import io.github.moacirrf.javadecompiler.Decompiler;
import io.github.moacirrf.javadecompiler.DecompilerFactory;
import io.github.moacirrf.javadecompiler.ExceptionHandler;
import io.github.moacirrf.javadecompiler.files.TempDir;
import io.github.moacirrf.javadecompiler.validator.FileValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.netbeans.api.java.source.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public final class DecompileAction
implements ActionListener {
    private final DataObject context;
    private final Path decompilerDir;

    public DecompileAction(DataObject context) {
        this.context = context;
        this.decompilerDir = TempDir.getTempDir();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        FileObject file = this.context.getPrimaryFile();
        if (FileValidator.validate(file)) {
            Decompiler decompiler = DecompilerFactory.create();
            this.writeToNewClass(file, (String)decompiler.decompile(file));
        }
    }

    private void writeToNewClass(FileObject file, String decompiled) {
        if (Objects.nonNull(decompiled) && !decompiled.isEmpty()) {
            Exceptions.wrap(ExceptionHandler::handleException).run(() -> {
                Path newFile = Path.of(this.decompilerDir.toString(), file.getName().concat(".java"));
                if (Files.exists(newFile, new LinkOption[0])) {
                    newFile.toFile().setWritable(true);
                    Files.delete(newFile);
                }
                Files.write(newFile, decompiled.getBytes(), new OpenOption[0]);
                newFile.toFile().setReadOnly();
                FileObject newFileObject = FileUtil.createData((File)newFile.toFile());
                newFileObject.setAttribute("disable-java-errors", (Object)true);
                UiUtils.open((FileObject)newFileObject, (int)1);
            });
        }
    }
}

