/*
 * Decompiled with CFR 0.152.
 */
package io.github.moacirrf.javadecompiler.cfr;

import com.machinezoo.noexception.Exceptions;
import io.github.moacirrf.javadecompiler.Decompiler;
import io.github.moacirrf.javadecompiler.ExceptionHandler;
import io.github.moacirrf.javadecompiler.cfr.NetbeansClassFileSourceImpl;
import io.github.moacirrf.javadecompiler.cfr.PluginDumperFactory;
import io.github.moacirrf.javadecompiler.files.FileSystemHelper;
import java.util.Map;
import org.benf.cfr.reader.Main;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.openide.filesystems.FileObject;

public final class DecompilerClassImpl
implements Decompiler<String, FileObject> {
    public static final String HEADER_COMMENT = "// Source code recreated by Apache Netbeans (NB Java Decompiler) \n";
    private final Options options = new OptionsImpl(Map.of("comments", "false", "innerclasses", "true"));

    @Override
    public String decompile(FileObject file) {
        return (String)Exceptions.wrap(ExceptionHandler::handleException).get(() -> {
            String className = FileSystemHelper.extractName(file);
            FileSystemHelper helper = FileSystemHelper.of(file);
            NetbeansClassFileSourceImpl classFileSource = new NetbeansClassFileSourceImpl(helper);
            StringBuilder out = new StringBuilder(HEADER_COMMENT);
            Main.doClass(new DCCommonState(this.options, classFileSource), className, false, new PluginDumperFactory(out, this.options));
            return out.toString();
        });
    }
}

