/*
 * Decompiled with CFR 0.152.
 */
package io.github.moacirrf.javadecompiler.cfr;

import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.state.TypeUsageInformation;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.Dumper;
import org.benf.cfr.reader.util.output.DumperFactory;
import org.benf.cfr.reader.util.output.ExceptionDumper;
import org.benf.cfr.reader.util.output.FileSummaryDumper;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.benf.cfr.reader.util.output.MethodErrorCollector;
import org.benf.cfr.reader.util.output.NopSummaryDumper;
import org.benf.cfr.reader.util.output.ProgressDumper;
import org.benf.cfr.reader.util.output.ProgressDumperNop;
import org.benf.cfr.reader.util.output.StringStreamDumper;
import org.benf.cfr.reader.util.output.SummaryDumper;
import org.openide.util.Exceptions;

public class PluginDumperFactory
implements DumperFactory {
    private final IllegalIdentifierDump illegalIdentifierDump = new IllegalIdentifierDump.Nop();
    private final StringBuilder outBuffer;
    private final Options options;

    public PluginDumperFactory(StringBuilder out, Options options) {
        this.outBuffer = out;
        this.options = options;
    }

    @Override
    public Dumper getNewTopLevelDumper(JavaTypeInstance classType, SummaryDumper summaryDumper, TypeUsageInformation typeUsageInformation, IllegalIdentifierDump illegalIdentifierDump) {
        return new StringStreamDumper(new MethodErrorCollector.SummaryDumperMethodErrorCollector(classType, summaryDumper), this.outBuffer, typeUsageInformation, this.options, this.illegalIdentifierDump);
    }

    @Override
    public Dumper wrapLineNoDumper(Dumper dumper) {
        return dumper;
    }

    @Override
    public SummaryDumper getSummaryDumper() {
        if (!this.options.optionIsSet(OptionsImpl.OUTPUT_DIR)) {
            return new NopSummaryDumper();
        }
        return new FileSummaryDumper((String)this.options.getOption(OptionsImpl.OUTPUT_DIR), this.options, null);
    }

    @Override
    public ProgressDumper getProgressDumper() {
        return ProgressDumperNop.INSTANCE;
    }

    @Override
    public ExceptionDumper getExceptionDumper() {
        return new ExceptionDumper(){

            @Override
            public void noteException(String path, String comment, Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        };
    }

    @Override
    public DumperFactory getFactoryWithPrefix(String prefix, int version) {
        return this;
    }
}

