/*
 * Decompiled with CFR 0.152.
 */
package io.github.moacirrf.javadecompiler.files;

import com.machinezoo.noexception.Exceptions;
import io.github.moacirrf.javadecompiler.ExceptionHandler;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

public final class FileSystemHelper {
    public static final String CLASSFILE_BINARY_NAME = "classfile-binaryName";
    public static final String CLASSFILE_ROOT = "classfile-root";
    private FileObject file;
    private ClassPath classpath;

    public static String extractName(FileObject file) {
        Object fileName = file.getAttribute(CLASSFILE_BINARY_NAME);
        if (Objects.nonNull(fileName)) {
            return String.valueOf(fileName);
        }
        return file.getPath();
    }

    public static FileSystemHelper of(FileObject fileObject) {
        FileSystemHelper input = new FileSystemHelper();
        input.file = fileObject;
        input.classpath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        return input;
    }

    private FileSystemHelper() {
    }

    public FileObject findResource(String internalName) {
        return (FileObject)Exceptions.wrap(ExceptionHandler::handleException).get(() -> {
            String ext = internalName.endsWith(".class") ? "" : ".class";
            FileObject fileObject = this.getClassFromJar(internalName + ext);
            if (Objects.isNull(fileObject)) {
                fileObject = this.getClassIfOpenEditor(internalName + ext);
            }
            if (Objects.isNull(fileObject) && Objects.nonNull(this.classpath)) {
                fileObject = this.classpath.findResource(internalName + ext);
            }
            return fileObject;
        });
    }

    private FileObject getClassIfOpenEditor(String internalName) throws FileStateInvalidException {
        URL url = (URL)this.file.getAttribute(CLASSFILE_ROOT);
        if (Objects.nonNull(url)) {
            FileObject jarFile = FileUtil.toFileObject((File)FileUtil.archiveOrDirForURL((URL)url));
            return FileUtil.getArchiveRoot((FileObject)jarFile).getFileSystem().findResource(internalName);
        }
        return null;
    }

    private FileObject getClassFromJar(String internalName) throws FileStateInvalidException {
        return this.file.getFileSystem().findResource(internalName);
    }
}

