/*
 * Decompiled with CFR 0.152.
 */
package io.github.moacirrf.javadecompiler.files;

import com.machinezoo.noexception.Exceptions;
import io.github.moacirrf.javadecompiler.ExceptionHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class TempDir {
    public static final String TEMP_DIR_PLUGIN = System.getProperty("java.io.tmpdir") + "/nb_java_decompiler";

    public static Path getTempDir() {
        Path path = Paths.get(TEMP_DIR_PLUGIN, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Exceptions.wrap(ExceptionHandler::handleException).run(() -> {
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectory(path, new FileAttribute[0]);
                }
            });
        }
        return path;
    }

    public static void removeTempDir() {
        TempDir.clearTempFolder(TempDir.getTempDir());
    }

    private static void clearTempFolder(Path path) {
        Exceptions.wrap(ExceptionHandler::handleException).run(() -> {
            if (Files.isDirectory(path, new LinkOption[0]) && Files.list(path).count() > 0L) {
                Files.list(path).forEach(it -> TempDir.clearTempFolder(it));
            }
            path.toFile().setWritable(true);
            Files.deleteIfExists(path);
        });
    }
}

