/*
 * Decompiled with CFR 0.152.
 */
package io.github.moacirrf.javadecompiler.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;

public final class FileValidator {
    private static final String INVALID_FILE = "Invalid file.";
    private static final String ACCEPTED_FILES = "Only %s files are accepted.";
    private static final List<String> ACCEPTED_EXTENSION = Arrays.asList("class");

    public static boolean validate(FileObject file) {
        if (Objects.nonNull(file)) {
            return FileValidator.isValidExtensions(file);
        }
        StatusDisplayer.getDefault().setStatusText(INVALID_FILE);
        return false;
    }

    private static boolean isValidExtensions(FileObject file) {
        if (!ACCEPTED_EXTENSION.contains(file.getExt().toLowerCase()) && !FileValidator.isClassOriginFromJar(file)) {
            String extension = ACCEPTED_EXTENSION.stream().collect(Collectors.joining(", "));
            StatusDisplayer.getDefault().setStatusText(String.format(ACCEPTED_FILES, extension));
            return false;
        }
        return true;
    }

    private static boolean isClassOriginFromJar(FileObject file) {
        return Objects.nonNull(file.getAttribute("classfile-root")) && Objects.nonNull(file.getAttribute("classfile-binaryName"));
    }

    private FileValidator() {
    }
}

