/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.Async;
import graphql.execution.ExecutionContext;
import graphql.execution.FieldValueInfo;
import graphql.execution.instrumentation.DocumentAndVariables;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.language.Document;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

@PublicApi
public class ChainedInstrumentation
implements Instrumentation {
    private final ImmutableList<Instrumentation> instrumentations;

    public ChainedInstrumentation(List<Instrumentation> instrumentations) {
        this.instrumentations = ImmutableList.copyOf((Collection)Assert.assertNotNull(instrumentations));
    }

    public ChainedInstrumentation(Instrumentation ... instrumentations) {
        this(Arrays.asList(instrumentations));
    }

    public List<Instrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    private InstrumentationState getState(Instrumentation instrumentation, InstrumentationState parametersInstrumentationState) {
        ChainedInstrumentationState chainedInstrumentationState = (ChainedInstrumentationState)parametersInstrumentationState;
        return chainedInstrumentationState.getState(instrumentation);
    }

    @Override
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new ChainedInstrumentationState(this.instrumentations, parameters);
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters) {
        return new ChainedInstrumentationContext<ExecutionResult>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginExecution(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<Document> beginParse(InstrumentationExecutionParameters parameters) {
        return new ChainedInstrumentationContext<Document>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginParse(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        return new ChainedInstrumentationContext<List<ValidationError>>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginValidation(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        return new ChainedInstrumentationContext<ExecutionResult>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginExecuteOperation(parameters.withNewState(state));
        }));
    }

    @Override
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters) {
        return new ChainedExecutionStrategyInstrumentationContext(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginExecutionStrategy(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginSubscribedFieldEvent(InstrumentationFieldParameters parameters) {
        return new ChainedInstrumentationContext<ExecutionResult>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginSubscribedFieldEvent(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginField(InstrumentationFieldParameters parameters) {
        return new ChainedInstrumentationContext<ExecutionResult>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginField(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        return new ChainedInstrumentationContext<Object>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginFieldFetch(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginFieldComplete(InstrumentationFieldCompleteParameters parameters) {
        return new ChainedInstrumentationContext<ExecutionResult>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginFieldComplete(parameters.withNewState(state));
        }));
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginFieldListComplete(InstrumentationFieldCompleteParameters parameters) {
        return new ChainedInstrumentationContext<ExecutionResult>(ImmutableKit.map(this.instrumentations, instrumentation -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            return instrumentation.beginFieldListComplete(parameters.withNewState(state));
        }));
    }

    @Override
    public ExecutionInput instrumentExecutionInput(ExecutionInput executionInput, InstrumentationExecutionParameters parameters) {
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState state = this.getState(instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            executionInput = instrumentation.instrumentExecutionInput(executionInput, parameters.withNewState(state));
        }
        return executionInput;
    }

    @Override
    public DocumentAndVariables instrumentDocumentAndVariables(DocumentAndVariables documentAndVariables, InstrumentationExecutionParameters parameters) {
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState state = this.getState(instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            documentAndVariables = instrumentation.instrumentDocumentAndVariables(documentAndVariables, parameters.withNewState(state));
        }
        return documentAndVariables;
    }

    @Override
    public GraphQLSchema instrumentSchema(GraphQLSchema schema, InstrumentationExecutionParameters parameters) {
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState state = this.getState(instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            schema = instrumentation.instrumentSchema(schema, parameters.withNewState(state));
        }
        return schema;
    }

    @Override
    public ExecutionContext instrumentExecutionContext(ExecutionContext executionContext, InstrumentationExecutionParameters parameters) {
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState state = this.getState(instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            executionContext = instrumentation.instrumentExecutionContext(executionContext, parameters.withNewState(state));
        }
        return executionContext;
    }

    @Override
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        for (Instrumentation instrumentation : this.instrumentations) {
            InstrumentationState state = this.getState(instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, parameters.withNewState(state));
        }
        return dataFetcher;
    }

    @Override
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        CompletableFuture resultsFuture = Async.eachSequentially(this.instrumentations, (instrumentation, index, prevResults) -> {
            InstrumentationState state = this.getState((Instrumentation)instrumentation, (InstrumentationState)parameters.getInstrumentationState());
            ExecutionResult lastResult = prevResults.size() > 0 ? (ExecutionResult)prevResults.get(prevResults.size() - 1) : executionResult;
            return instrumentation.instrumentExecutionResult(lastResult, parameters.withNewState(state));
        });
        return resultsFuture.thenApply(results -> results.isEmpty() ? executionResult : (ExecutionResult)results.get(results.size() - 1));
    }

    private static class ChainedInstrumentationState
    implements InstrumentationState {
        private final Map<Instrumentation, InstrumentationState> instrumentationStates;

        private ChainedInstrumentationState(List<Instrumentation> instrumentations, InstrumentationCreateStateParameters parameters) {
            this.instrumentationStates = new LinkedHashMap<Instrumentation, InstrumentationState>(instrumentations.size());
            instrumentations.forEach(i -> this.instrumentationStates.put((Instrumentation)i, i.createState(parameters)));
        }

        private InstrumentationState getState(Instrumentation instrumentation) {
            return this.instrumentationStates.get(instrumentation);
        }
    }

    private static class ChainedInstrumentationContext<T>
    implements InstrumentationContext<T> {
        private final ImmutableList<InstrumentationContext<T>> contexts;

        ChainedInstrumentationContext(List<InstrumentationContext<T>> contexts) {
            this.contexts = ImmutableList.copyOf(contexts);
        }

        @Override
        public void onDispatched(CompletableFuture<T> result) {
            this.contexts.forEach((Consumer<InstrumentationContext<T>>)((Consumer<InstrumentationContext>)context -> context.onDispatched(result)));
        }

        @Override
        public void onCompleted(T result, Throwable t) {
            this.contexts.forEach((Consumer<InstrumentationContext<T>>)((Consumer<InstrumentationContext>)context -> context.onCompleted(result, t)));
        }
    }

    private static class ChainedExecutionStrategyInstrumentationContext
    implements ExecutionStrategyInstrumentationContext {
        private final ImmutableList<ExecutionStrategyInstrumentationContext> contexts;

        ChainedExecutionStrategyInstrumentationContext(List<ExecutionStrategyInstrumentationContext> contexts) {
            this.contexts = ImmutableList.copyOf(contexts);
        }

        @Override
        public void onDispatched(CompletableFuture<ExecutionResult> result) {
            this.contexts.forEach(context -> context.onDispatched(result));
        }

        @Override
        public void onCompleted(ExecutionResult result, Throwable t) {
            this.contexts.forEach(context -> context.onCompleted(result, t));
        }

        @Override
        public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
            this.contexts.forEach(context -> context.onFieldValuesInfo(fieldValueInfoList));
        }
    }
}

