/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractNode;
import graphql.language.Comment;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.IgnoredChars;
import graphql.language.Node;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.language.SourceLocation;
import graphql.language.VariableDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class OperationDefinition
extends AbstractNode<OperationDefinition>
implements Definition<OperationDefinition>,
SelectionSetContainer<OperationDefinition>,
DirectivesContainer<OperationDefinition> {
    private final String name;
    private final Operation operation;
    private final ImmutableList<VariableDefinition> variableDefinitions;
    private final ImmutableList<Directive> directives;
    private final SelectionSet selectionSet;
    public static final String CHILD_VARIABLE_DEFINITIONS = "variableDefinitions";
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_SELECTION_SET = "selectionSet";

    @Internal
    protected OperationDefinition(String name, Operation operation, List<VariableDefinition> variableDefinitions, List<Directive> directives, SelectionSet selectionSet, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.name = name;
        this.operation = operation;
        this.variableDefinitions = ImmutableList.copyOf(variableDefinitions);
        this.directives = ImmutableList.copyOf(directives);
        this.selectionSet = selectionSet;
    }

    public OperationDefinition(String name, Operation operation) {
        this(name, operation, ImmutableKit.emptyList(), ImmutableKit.emptyList(), null, null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    public OperationDefinition(String name) {
        this(name, null, ImmutableKit.emptyList(), ImmutableKit.emptyList(), null, null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.variableDefinitions);
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_VARIABLE_DEFINITIONS, this.variableDefinitions).children(CHILD_DIRECTIVES, this.directives).child(CHILD_SELECTION_SET, this.selectionSet).build();
    }

    @Override
    public OperationDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> ((Builder)builder.variableDefinitions(newChildren.getChildren(CHILD_VARIABLE_DEFINITIONS)).directives(newChildren.getChildren(CHILD_DIRECTIVES))).selectionSet((SelectionSet)newChildren.getChildOrNull(CHILD_SELECTION_SET)));
    }

    public String getName() {
        return this.name;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)o;
        return Objects.equals(this.name, that.name) && this.operation == that.operation;
    }

    @Override
    public OperationDefinition deepCopy() {
        return new OperationDefinition(this.name, this.operation, this.deepCopy(this.variableDefinitions), this.deepCopy(this.directives), this.deepCopy(this.selectionSet), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "OperationDefinition{name='" + this.name + '\'' + ", operation=" + (Object)((Object)this.operation) + ", variableDefinitions=" + this.variableDefinitions + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitOperationDefinition(this, context);
    }

    public static Builder newOperationDefinition() {
        return new Builder();
    }

    public OperationDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static enum Operation {
        QUERY,
        MUTATION,
        SUBSCRIPTION;

    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private String name;
        private Operation operation;
        private ImmutableList<VariableDefinition> variableDefinitions = ImmutableKit.emptyList();
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private SelectionSet selectionSet;
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(OperationDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.name = existing.getName();
            this.operation = existing.getOperation();
            this.variableDefinitions = ImmutableList.copyOf(existing.getVariableDefinitions());
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.selectionSet = existing.getSelectionSet();
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder variableDefinitions(List<VariableDefinition> variableDefinitions) {
            this.variableDefinitions = ImmutableList.copyOf(variableDefinitions);
            return this;
        }

        public Builder variableDefinition(VariableDefinition variableDefinition) {
            this.variableDefinitions = ImmutableKit.addToList(this.variableDefinitions, variableDefinition, new VariableDefinition[0]);
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        public Builder selectionSet(SelectionSet selectionSet) {
            this.selectionSet = selectionSet;
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public OperationDefinition build() {
            return new OperationDefinition(this.name, this.operation, this.variableDefinitions, this.directives, this.selectionSet, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

