/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Map;

@Internal
public class GraphQLTypeResolvingVisitor
extends GraphQLTypeVisitorStub {
    protected final Map<String, GraphQLNamedType> typeMap;

    public GraphQLTypeResolvingVisitor(Map<String, GraphQLNamedType> typeMap) {
        this.typeMap = typeMap;
    }

    @Override
    public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        node.replaceInterfaces(ImmutableKit.map(node.getInterfaces(), type -> (GraphQLNamedOutputType)this.typeMap.get(type.getName())));
        return super.visitGraphQLObjectType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> context) {
        node.replaceInterfaces(ImmutableKit.map(node.getInterfaces(), type -> (GraphQLNamedOutputType)this.typeMap.get(type.getName())));
        return super.visitGraphQLInterfaceType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLSchemaElement> context) {
        node.replaceTypes(ImmutableKit.map(node.getTypes(), type -> (GraphQLNamedOutputType)this.typeMap.get(type.getName())));
        return super.visitGraphQLUnionType(node, context);
    }

    @Override
    public TraversalControl visitGraphQLTypeReference(GraphQLTypeReference node, TraverserContext<GraphQLSchemaElement> context) {
        return this.handleTypeReference(node, context);
    }

    public TraversalControl handleTypeReference(GraphQLTypeReference node, TraverserContext<GraphQLSchemaElement> context) {
        GraphQLType resolvedType = this.typeMap.get(node.getName());
        Assert.assertNotNull(resolvedType, () -> String.format("type %s not found in schema", node.getName()));
        context.getParentContext().thisNode().accept(context, new TypeRefResolvingVisitor(resolvedType));
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitBackRef(TraverserContext<GraphQLSchemaElement> context) {
        GraphQLSchemaElement schemaElement = context.thisNode();
        if (schemaElement instanceof GraphQLTypeReference) {
            return this.handleTypeReference((GraphQLTypeReference)schemaElement, context);
        }
        return TraversalControl.CONTINUE;
    }

    private class TypeRefResolvingVisitor
    extends GraphQLTypeVisitorStub {
        protected final GraphQLType resolvedType;

        TypeRefResolvingVisitor(GraphQLType resolvedType) {
            this.resolvedType = resolvedType;
        }

        @Override
        public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLSchemaElement> context) {
            node.replaceType((GraphQLOutputType)this.resolvedType);
            return super.visitGraphQLFieldDefinition(node, context);
        }

        @Override
        public TraversalControl visitGraphQLArgument(GraphQLArgument node, TraverserContext<GraphQLSchemaElement> context) {
            node.replaceType((GraphQLInputType)this.resolvedType);
            return super.visitGraphQLArgument(node, context);
        }

        @Override
        public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField node, TraverserContext<GraphQLSchemaElement> context) {
            node.replaceType((GraphQLInputType)this.resolvedType);
            return super.visitGraphQLInputObjectField(node, context);
        }

        @Override
        public TraversalControl visitGraphQLList(GraphQLList node, TraverserContext<GraphQLSchemaElement> context) {
            node.replaceType(this.resolvedType);
            return super.visitGraphQLList(node, context);
        }

        @Override
        public TraversalControl visitGraphQLNonNull(GraphQLNonNull node, TraverserContext<GraphQLSchemaElement> context) {
            node.replaceType(this.resolvedType);
            return super.visitGraphQLNonNull(node, context);
        }
    }
}

