/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.CoercedVariables;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedSelectionSet;
import graphql.execution.MissingRootTypeException;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.RawVariables;
import graphql.execution.ResultPath;
import graphql.execution.ValueUnboxer;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.util.LogKit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

@Internal
public class Execution {
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(Execution.class);
    private final FieldCollector fieldCollector = new FieldCollector();
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final Instrumentation instrumentation;
    private ValueUnboxer valueUnboxer;

    public Execution(ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Instrumentation instrumentation, ValueUnboxer valueUnboxer) {
        this.queryStrategy = queryStrategy != null ? queryStrategy : new AsyncExecutionStrategy();
        this.mutationStrategy = mutationStrategy != null ? mutationStrategy : new AsyncSerialExecutionStrategy();
        this.subscriptionStrategy = subscriptionStrategy != null ? subscriptionStrategy : new AsyncExecutionStrategy();
        this.instrumentation = instrumentation;
        this.valueUnboxer = valueUnboxer;
    }

    public CompletableFuture<ExecutionResult> execute(Document document, GraphQLSchema graphQLSchema, ExecutionId executionId, ExecutionInput executionInput, InstrumentationState instrumentationState) {
        CoercedVariables coercedVariables;
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, executionInput.getOperationName());
        Map<String, FragmentDefinition> fragmentsByName = getOperationResult.fragmentsByName;
        OperationDefinition operationDefinition = getOperationResult.operationDefinition;
        RawVariables inputVariables = executionInput.getRawVariables();
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        try {
            coercedVariables = ValuesResolver.coerceVariableValues(graphQLSchema, variableDefinitions, inputVariables);
        }
        catch (RuntimeException rte) {
            if (rte instanceof GraphQLError) {
                return CompletableFuture.completedFuture(new ExecutionResultImpl((GraphQLError)((Object)rte)));
            }
            throw rte;
        }
        ExecutionContext executionContext = ExecutionContextBuilder.newExecutionContextBuilder().instrumentation(this.instrumentation).instrumentationState(instrumentationState).executionId(executionId).graphQLSchema(graphQLSchema).queryStrategy(this.queryStrategy).mutationStrategy(this.mutationStrategy).subscriptionStrategy(this.subscriptionStrategy).context(executionInput.getContext()).graphQLContext(executionInput.getGraphQLContext()).localContext(executionInput.getLocalContext()).root(executionInput.getRoot()).fragmentsByName(fragmentsByName).coercedVariables(coercedVariables).document(document).operationDefinition(operationDefinition).dataLoaderRegistry(executionInput.getDataLoaderRegistry()).cacheControl(executionInput.getCacheControl()).locale(executionInput.getLocale()).valueUnboxer(this.valueUnboxer).executionInput(executionInput).build();
        InstrumentationExecutionParameters parameters = new InstrumentationExecutionParameters(executionInput, graphQLSchema, instrumentationState);
        executionContext = this.instrumentation.instrumentExecutionContext(executionContext, parameters, instrumentationState);
        return this.executeOperation(executionContext, executionInput.getRoot(), executionContext.getOperationDefinition());
    }

    private CompletableFuture<ExecutionResult> executeOperation(ExecutionContext executionContext, Object root, OperationDefinition operationDefinition) {
        CompletableFuture<ExecutionResult> result;
        GraphQLObjectType operationRootType;
        InstrumentationExecuteOperationParameters instrumentationParams = new InstrumentationExecuteOperationParameters(executionContext);
        InstrumentationContext<ExecutionResult> executeOperationCtx = SimpleInstrumentationContext.nonNullCtx(this.instrumentation.beginExecuteOperation(instrumentationParams, executionContext.getInstrumentationState()));
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        try {
            operationRootType = this.getOperationRootType(executionContext.getGraphQLSchema(), operationDefinition);
        }
        catch (RuntimeException rte) {
            if (rte instanceof GraphQLError) {
                ExecutionResultImpl executionResult = new ExecutionResultImpl(Collections.singletonList((GraphQLError)((Object)rte)));
                CompletableFuture<ExecutionResult> resultCompletableFuture = CompletableFuture.completedFuture(executionResult);
                executeOperationCtx.onDispatched(resultCompletableFuture);
                executeOperationCtx.onCompleted(executionResult, rte);
                return resultCompletableFuture;
            }
            throw rte;
        }
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(operationRootType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        MergedSelectionSet fields = this.fieldCollector.collectFields(collectorParameters, operationDefinition.getSelectionSet());
        ResultPath path = ResultPath.rootPath();
        ExecutionStepInfo executionStepInfo = ExecutionStepInfo.newExecutionStepInfo().type(operationRootType).path(path).build();
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, executionStepInfo);
        ExecutionStrategyParameters parameters = ExecutionStrategyParameters.newParameters().executionStepInfo(executionStepInfo).source(root).localContext(executionContext.getLocalContext()).fields(fields).nonNullFieldValidator(nonNullableFieldValidator).path(path).build();
        try {
            ExecutionStrategy executionStrategy = executionContext.getStrategy(operation);
            if (logNotSafe.isDebugEnabled()) {
                logNotSafe.debug("Executing '{}' query operation: '{}' using '{}' execution strategy", new Object[]{executionContext.getExecutionId(), operation, executionStrategy.getClass().getName()});
            }
            result = executionStrategy.execute(executionContext, parameters);
        }
        catch (NonNullableFieldWasNullException e) {
            result = CompletableFuture.completedFuture(new ExecutionResultImpl(null, executionContext.getErrors()));
        }
        executeOperationCtx.onDispatched(result);
        result = result.whenComplete(executeOperationCtx::onCompleted);
        return result;
    }

    private GraphQLObjectType getOperationRootType(GraphQLSchema graphQLSchema, OperationDefinition operationDefinition) {
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        if (operation == OperationDefinition.Operation.MUTATION) {
            GraphQLObjectType mutationType = graphQLSchema.getMutationType();
            if (mutationType == null) {
                throw new MissingRootTypeException("Schema is not configured for mutations.", operationDefinition.getSourceLocation());
            }
            return mutationType;
        }
        if (operation == OperationDefinition.Operation.QUERY) {
            GraphQLObjectType queryType = graphQLSchema.getQueryType();
            if (queryType == null) {
                throw new MissingRootTypeException("Schema does not define the required query root type.", operationDefinition.getSourceLocation());
            }
            return queryType;
        }
        if (operation == OperationDefinition.Operation.SUBSCRIPTION) {
            GraphQLObjectType subscriptionType = graphQLSchema.getSubscriptionType();
            if (subscriptionType == null) {
                throw new MissingRootTypeException("Schema is not configured for subscriptions.", operationDefinition.getSourceLocation());
            }
            return subscriptionType;
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen("Unhandled case.  An extra operation enum has been added without code support", new Object[0]);
    }
}

