/*
 * Decompiled with CFR 0.152.
 */
package graphql.i18n;

import graphql.Assert;
import graphql.Internal;
import graphql.VisibleForTesting;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Internal
public class I18n {
    private final ResourceBundle resourceBundle;

    @VisibleForTesting
    protected I18n(BundleType bundleType, Locale locale) {
        Assert.assertNotNull(bundleType);
        Assert.assertNotNull(locale);
        this.resourceBundle = ResourceBundle.getBundle(bundleType.baseName, locale);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static I18n i18n(BundleType bundleType, Locale locale) {
        return new I18n(bundleType, locale);
    }

    public String msg(String msgKey, Object ... msgArgs) {
        String msgPattern = null;
        try {
            msgPattern = this.resourceBundle.getString(msgKey);
        }
        catch (MissingResourceException e) {
            Assert.assertShouldNeverHappen("There must be a resource bundle key called %s", msgKey);
        }
        String formattedMsg = new MessageFormat(msgPattern).format(msgArgs);
        return formattedMsg;
    }

    public static enum BundleType {
        Validation,
        Execution,
        General;

        private final String baseName = "i18n." + this.name();
    }
}

