/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.PublicApi;
import graphql.language.Document;
import graphql.language.Node;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.Value;
import graphql.org.antlr.v4.runtime.BaseErrorListener;
import graphql.org.antlr.v4.runtime.CharStreams;
import graphql.org.antlr.v4.runtime.CodePointCharStream;
import graphql.org.antlr.v4.runtime.CommonTokenStream;
import graphql.org.antlr.v4.runtime.ParserRuleContext;
import graphql.org.antlr.v4.runtime.RecognitionException;
import graphql.org.antlr.v4.runtime.Recognizer;
import graphql.org.antlr.v4.runtime.Token;
import graphql.org.antlr.v4.runtime.atn.ParserATNSimulator;
import graphql.org.antlr.v4.runtime.atn.PredictionMode;
import graphql.org.antlr.v4.runtime.tree.TerminalNode;
import graphql.parser.AntlrHelper;
import graphql.parser.ExtendedBailStrategy;
import graphql.parser.GraphqlAntlrToLanguage;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.MultiSourceReader;
import graphql.parser.ParseCancelledException;
import graphql.parser.ParserOptions;
import graphql.parser.ParsingListener;
import graphql.parser.SafeTokenSource;
import graphql.parser.antlr.GraphqlBaseListener;
import graphql.parser.antlr.GraphqlLexer;
import graphql.parser.antlr.GraphqlParser;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

@PublicApi
public class Parser {
    @Internal
    public static final int CHANNEL_COMMENTS = 2;
    @Internal
    public static final int CHANNEL_WHITESPACE = 3;

    public static Document parse(String input) throws InvalidSyntaxException {
        return new Parser().parseDocument(input);
    }

    public static Value<?> parseValue(String input) throws InvalidSyntaxException {
        return new Parser().parseValueImpl(input);
    }

    public static Type<?> parseType(String input) throws InvalidSyntaxException {
        return new Parser().parseTypeImpl(input);
    }

    public Document parseDocument(String input) throws InvalidSyntaxException {
        return this.parseDocument(input, (ParserOptions)null);
    }

    public Document parseDocument(String input, String sourceName) throws InvalidSyntaxException {
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, sourceName).trackData(true).build();
        return this.parseDocument(multiSourceReader);
    }

    public Document parseDocument(String input, ParserOptions parserOptions) throws InvalidSyntaxException {
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, null).trackData(true).build();
        return this.parseDocument(multiSourceReader, parserOptions);
    }

    public Document parseDocument(Reader reader) throws InvalidSyntaxException {
        return this.parseDocumentImpl(reader, null);
    }

    public Document parseDocument(Reader reader, ParserOptions parserOptions) throws InvalidSyntaxException {
        return this.parseDocumentImpl(reader, parserOptions);
    }

    private Document parseDocumentImpl(Reader reader, ParserOptions parserOptions) throws InvalidSyntaxException {
        BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction = (parser, toLanguage) -> {
            GraphqlParser.DocumentContext documentContext = parser.document();
            Document doc = toLanguage.createDocument(documentContext);
            return new Object[]{documentContext, doc};
        };
        return (Document)this.parseImpl(reader, nodeFunction, parserOptions);
    }

    private Value<?> parseValueImpl(String input) throws InvalidSyntaxException {
        BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction = (parser, toLanguage) -> {
            GraphqlParser.ValueContext documentContext = parser.value();
            Value value = toLanguage.createValue(documentContext);
            return new Object[]{documentContext, value};
        };
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, null).trackData(true).build();
        return (Value)this.parseImpl(multiSourceReader, nodeFunction, null);
    }

    private Type<?> parseTypeImpl(String input) throws InvalidSyntaxException {
        BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction = (parser, toLanguage) -> {
            GraphqlParser.TypeContext documentContext = parser.type();
            Type value = toLanguage.createType(documentContext);
            return new Object[]{documentContext, value};
        };
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, null).trackData(true).build();
        return (Type)this.parseImpl(multiSourceReader, nodeFunction, null);
    }

    private Node<?> parseImpl(Reader reader, BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction, ParserOptions parserOptions) throws InvalidSyntaxException {
        CodePointCharStream charStream;
        final MultiSourceReader multiSourceReader = reader instanceof MultiSourceReader ? (MultiSourceReader)reader : MultiSourceReader.newMultiSourceReader().reader(reader, null).build();
        try {
            charStream = CharStreams.fromReader(multiSourceReader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        GraphqlLexer lexer = new GraphqlLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                SourceLocation sourceLocation = AntlrHelper.createSourceLocation(multiSourceReader, line, charPositionInLine);
                String preview = AntlrHelper.createPreview(multiSourceReader, line);
                throw new InvalidSyntaxException(sourceLocation, msg, preview, null, null);
            }
        });
        parserOptions = Optional.ofNullable(parserOptions).orElse(ParserOptions.getDefaultParserOptions());
        int maxTokens = parserOptions.getMaxTokens();
        int maxWhitespaceTokens = parserOptions.getMaxWhitespaceTokens();
        BiConsumer<Integer, Token> onTooManyTokens = (maxTokenCount, token) -> this.throwCancelParseIfTooManyTokens((Token)token, (int)maxTokenCount, multiSourceReader);
        SafeTokenSource safeTokenSource = new SafeTokenSource(lexer, maxTokens, maxWhitespaceTokens, onTooManyTokens);
        CommonTokenStream tokens = new CommonTokenStream(safeTokenSource);
        GraphqlParser parser = new GraphqlParser(tokens);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        ExtendedBailStrategy bailStrategy = new ExtendedBailStrategy(multiSourceReader);
        parser.setErrorHandler(bailStrategy);
        GraphqlAntlrToLanguage toLanguage = this.getAntlrToLanguage(tokens, multiSourceReader);
        if (toLanguage == null) {
            toLanguage = this.getAntlrToLanguage(tokens, multiSourceReader, parserOptions);
        }
        this.setupParserListener(multiSourceReader, parser, toLanguage);
        Object[] contextAndNode = nodeFunction.apply(parser, toLanguage);
        ParserRuleContext parserRuleContext = (ParserRuleContext)contextAndNode[0];
        Node node = (Node)contextAndNode[1];
        Token stop = parserRuleContext.getStop();
        List<Token> allTokens = tokens.getTokens();
        if (stop != null && allTokens != null && !allTokens.isEmpty()) {
            boolean sameChannel;
            Token last = allTokens.get(allTokens.size() - 1);
            boolean notEOF = last.getType() != -1;
            boolean lastGreaterThanDocument = last.getTokenIndex() > stop.getTokenIndex();
            boolean bl = sameChannel = last.getChannel() == stop.getChannel();
            if (notEOF && lastGreaterThanDocument && sameChannel) {
                throw bailStrategy.mkMoreTokensException(last);
            }
        }
        return node;
    }

    private void setupParserListener(final MultiSourceReader multiSourceReader, GraphqlParser parser, GraphqlAntlrToLanguage toLanguage) {
        ParserOptions parserOptions = toLanguage.getParserOptions();
        final ParsingListener parsingListener = parserOptions.getParsingListener();
        final int maxTokens = parserOptions.getMaxTokens();
        GraphqlBaseListener listener = new GraphqlBaseListener(){
            int count = 0;

            @Override
            public void visitTerminal(TerminalNode node) {
                final Token token = node.getSymbol();
                parsingListener.onToken(new ParsingListener.Token(){

                    @Override
                    public String getText() {
                        return token == null ? null : token.getText();
                    }

                    @Override
                    public int getLine() {
                        return token == null ? -1 : token.getLine();
                    }

                    @Override
                    public int getCharPositionInLine() {
                        return token == null ? -1 : token.getCharPositionInLine();
                    }
                });
                ++this.count;
                if (this.count > maxTokens) {
                    Parser.this.throwCancelParseIfTooManyTokens(token, maxTokens, multiSourceReader);
                }
            }
        };
        parser.addParseListener(listener);
    }

    private void throwCancelParseIfTooManyTokens(Token token, int maxTokens, MultiSourceReader multiSourceReader) throws ParseCancelledException {
        String tokenType = "grammar";
        SourceLocation sourceLocation = null;
        String offendingToken = null;
        if (token != null) {
            int channel = token.getChannel();
            tokenType = channel == 3 ? "whitespace" : (channel == 2 ? "comments" : "grammar");
            offendingToken = token.getText();
            sourceLocation = AntlrHelper.createSourceLocation(multiSourceReader, token.getLine(), token.getCharPositionInLine());
        }
        String msg = String.format("More than %d %s tokens have been presented. To prevent Denial Of Service attacks, parsing has been cancelled.", maxTokens, tokenType);
        throw new ParseCancelledException(msg, sourceLocation, offendingToken);
    }

    @Deprecated
    protected GraphqlAntlrToLanguage getAntlrToLanguage(CommonTokenStream tokens, MultiSourceReader multiSourceReader) {
        return null;
    }

    protected GraphqlAntlrToLanguage getAntlrToLanguage(CommonTokenStream tokens, MultiSourceReader multiSourceReader, ParserOptions parserOptions) {
        return new GraphqlAntlrToLanguage(tokens, multiSourceReader, parserOptions);
    }
}

