/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.PublicApi;
import graphql.execution.ValuesResolver;
import graphql.language.InputValueDefinition;
import graphql.language.Value;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.InputValueWithState;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class GraphQLArgument
implements GraphQLNamedSchemaElement,
GraphQLInputValueDefinition {
    private final String name;
    private final String description;
    private final String deprecationReason;
    private final GraphQLInputType originalType;
    private GraphQLInputType replacedType;
    private final InputValueWithState defaultValue;
    private final InputValueWithState value;
    private final InputValueDefinition definition;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    public static final String CHILD_TYPE = "type";

    private GraphQLArgument(String name, String description, GraphQLInputType type, InputValueWithState defaultValue, InputValueWithState value, InputValueDefinition definition, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, String deprecationReason) {
        Assert.assertValidName(name);
        Assert.assertNotNull(type, () -> "type can't be null");
        this.name = name;
        this.description = description;
        this.originalType = type;
        this.defaultValue = defaultValue;
        this.value = value;
        this.definition = definition;
        this.deprecationReason = deprecationReason;
        this.directivesHolder = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
    }

    void replaceType(GraphQLInputType type) {
        this.replacedType = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GraphQLInputType getType() {
        return this.replacedType != null ? this.replacedType : this.originalType;
    }

    @NotNull
    public InputValueWithState getArgumentDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasSetDefaultValue() {
        return this.defaultValue.isSet();
    }

    public boolean hasSetValue() {
        return this.value.isSet();
    }

    @Deprecated
    @NotNull
    public InputValueWithState getArgumentValue() {
        return this.value;
    }

    @Deprecated
    public static <T> T getArgumentValue(GraphQLArgument argument) {
        return ValuesResolver.getInputValueImpl(argument.getType(), argument.getArgumentValue());
    }

    public static <T> T getArgumentDefaultValue(GraphQLArgument argument) {
        return ValuesResolver.getInputValueImpl(argument.getType(), argument.getArgumentDefaultValue());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    @Override
    public InputValueDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>();
        children.add(this.getType());
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(CHILD_TYPE, this.originalType).children("directives", this.directivesHolder.getDirectives()).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).build();
    }

    @Override
    public GraphQLArgument withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.type((GraphQLInputType)newChildren.getChildOrNull(CHILD_TYPE)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLArgument.newArgument(this).build();
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public GraphQLArgument transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLArgument.newArgument(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newArgument() {
        return new Builder();
    }

    public static Builder newArgument(GraphQLArgument existing) {
        return new Builder(existing);
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLArgument(this, context);
    }

    public String toString() {
        return "GraphQLArgument{name='" + this.name + '\'' + ", value=" + this.value + ", defaultValue=" + this.defaultValue + ", type=" + this.getType() + '}';
    }

    public GraphQLAppliedDirectiveArgument toAppliedArgument() {
        return ((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(this.name)).type(this.getType()).inputValueWithState(this.value).build();
    }

    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private GraphQLInputType type;
        private InputValueWithState defaultValue = InputValueWithState.NOT_SET;
        private InputValueWithState value = InputValueWithState.NOT_SET;
        private String deprecationReason;
        private InputValueDefinition definition;

        public Builder() {
        }

        public Builder(GraphQLArgument existing) {
            this.name = existing.getName();
            this.type = existing.originalType;
            this.value = existing.getArgumentValue();
            this.defaultValue = existing.defaultValue;
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.deprecationReason = existing.deprecationReason;
            this.copyExistingDirectives(existing);
        }

        public Builder definition(InputValueDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder deprecate(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder type(GraphQLInputType type) {
            this.type = type;
            return this;
        }

        @Deprecated
        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = InputValueWithState.newInternalValue(defaultValue);
            return this;
        }

        public Builder defaultValueLiteral(@NotNull Value defaultValue) {
            this.defaultValue = InputValueWithState.newLiteralValue(defaultValue);
            return this;
        }

        public Builder defaultValueProgrammatic(@Nullable Object defaultValue) {
            this.defaultValue = InputValueWithState.newExternalValue(defaultValue);
            return this;
        }

        public Builder clearDefaultValue() {
            this.defaultValue = InputValueWithState.NOT_SET;
            return this;
        }

        @Deprecated
        public Builder value(@Nullable Object value) {
            this.value = InputValueWithState.newInternalValue(value);
            return this;
        }

        @Deprecated
        public Builder valueLiteral(@NotNull Value value) {
            this.value = InputValueWithState.newLiteralValue(value);
            return this;
        }

        @Deprecated
        public Builder valueProgrammatic(@Nullable Object value) {
            this.value = InputValueWithState.newExternalValue(value);
            return this;
        }

        @Deprecated
        public Builder clearValue() {
            this.value = InputValueWithState.NOT_SET;
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLArgument build() {
            Assert.assertNotNull(this.type, () -> "type can't be null");
            return new GraphQLArgument(this.name, this.description, this.type, this.defaultValue, this.value, this.definition, this.sort(this.directives, GraphQLArgument.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLScalarType.class, GraphQLAppliedDirective.class), this.deprecationReason);
        }
    }
}

