/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.EnumValueDefinition;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLEnumValueDefinition
implements GraphQLNamedSchemaElement,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Object value;
    private final String deprecationReason;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    private final EnumValueDefinition definition;

    @Internal
    private GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, EnumValueDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.value = value;
        this.deprecationReason = deprecationReason;
        this.directivesHolder = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
        this.definition = definition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public EnumValueDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    public GraphQLEnumValueDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLEnumValueDefinition.newEnumValueDefinition(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLEnumValueDefinition.newEnumValueDefinition(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLEnumValueDefinition(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>();
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children("directives", this.directivesHolder.getDirectives()).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).build();
    }

    @Override
    public GraphQLEnumValueDefinition withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "GraphQLEnumValueDefinition{name='" + this.name + '\'' + '}';
    }

    public static Builder newEnumValueDefinition() {
        return new Builder();
    }

    public static Builder newEnumValueDefinition(GraphQLEnumValueDefinition existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private Object value;
        private String deprecationReason;
        private EnumValueDefinition definition;

        public Builder() {
        }

        public Builder(GraphQLEnumValueDefinition existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.value = existing.getValue();
            this.deprecationReason = existing.getDeprecationReason();
            this.copyExistingDirectives(existing);
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder deprecationReason(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder definition(EnumValueDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLEnumValueDefinition build() {
            return new GraphQLEnumValueDefinition(this.name, this.description, this.value, this.deprecationReason, this.sort(this.directives, GraphQLScalarType.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLScalarType.class, GraphQLAppliedDirective.class), this.definition);
        }
    }
}

