/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.GraphqlTypeComparators;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.schema.TypeResolver;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLInterfaceType
implements GraphQLNamedType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer,
GraphQLImplementingType {
    private final String name;
    private final String description;
    private final Map<String, GraphQLFieldDefinition> fieldDefinitionsByName = new LinkedHashMap<String, GraphQLFieldDefinition>();
    private final TypeResolver typeResolver;
    private final InterfaceTypeDefinition definition;
    private final ImmutableList<InterfaceTypeExtensionDefinition> extensionDefinitions;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    private final ImmutableList<GraphQLNamedOutputType> originalInterfaces;
    private final Comparator<? super GraphQLSchemaElement> interfaceComparator;
    private ImmutableList<GraphQLNamedOutputType> replacedInterfaces;
    public static final String CHILD_FIELD_DEFINITIONS = "fieldDefinitions";
    public static final String CHILD_INTERFACES = "interfaces";

    @Internal
    private GraphQLInterfaceType(String name, String description, List<GraphQLFieldDefinition> fieldDefinitions, TypeResolver typeResolver, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, InterfaceTypeDefinition definition, List<InterfaceTypeExtensionDefinition> extensionDefinitions, List<GraphQLNamedOutputType> interfaces, Comparator<? super GraphQLSchemaElement> interfaceComparator) {
        Assert.assertValidName(name);
        Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't null");
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.description = description;
        this.typeResolver = typeResolver;
        this.definition = definition;
        this.interfaceComparator = interfaceComparator;
        this.originalInterfaces = ImmutableList.copyOf(GraphqlTypeComparators.sortTypes(interfaceComparator, interfaces));
        this.extensionDefinitions = ImmutableList.copyOf(extensionDefinitions);
        this.directivesHolder = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
        this.buildDefinitionMap(fieldDefinitions);
    }

    private void buildDefinitionMap(List<GraphQLFieldDefinition> fieldDefinitions) {
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            String name = fieldDefinition.getName();
            if (this.fieldDefinitionsByName.containsKey(name)) {
                throw new AssertException(String.format("Duplicated definition for field '%s' in interface '%s'", name, this.name));
            }
            this.fieldDefinitionsByName.put(name, fieldDefinition);
        }
    }

    @Override
    public GraphQLFieldDefinition getFieldDefinition(String name) {
        return this.fieldDefinitionsByName.get(name);
    }

    @Override
    public List<GraphQLFieldDefinition> getFieldDefinitions() {
        return ImmutableList.copyOf(this.fieldDefinitionsByName.values());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public InterfaceTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<InterfaceTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    public String toString() {
        return "GraphQLInterfaceType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", fieldDefinitionsByName=" + this.fieldDefinitionsByName.keySet() + ", typeResolver=" + this.typeResolver + '}';
    }

    public GraphQLInterfaceType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInterfaceType.newInterface(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLInterfaceType.newInterface(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInterfaceType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.fieldDefinitionsByName.values());
        children.addAll(this.getInterfaces());
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_FIELD_DEFINITIONS, this.fieldDefinitionsByName.values()).children(CHILD_INTERFACES, this.originalInterfaces).children("directives", this.directivesHolder.getDirectives()).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).build();
    }

    @Override
    public GraphQLInterfaceType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> ((Builder)builder.replaceDirectives(newChildren.getChildren("directives"))).replaceFields(newChildren.getChildren(CHILD_FIELD_DEFINITIONS)).replaceInterfacesOrReferences(newChildren.getChildren(CHILD_INTERFACES)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public List<GraphQLNamedOutputType> getInterfaces() {
        if (this.replacedInterfaces != null) {
            return ImmutableList.copyOf(this.replacedInterfaces);
        }
        return ImmutableList.copyOf(this.originalInterfaces);
    }

    void replaceInterfaces(List<GraphQLNamedOutputType> interfaces) {
        this.replacedInterfaces = ImmutableList.copyOf(GraphqlTypeComparators.sortTypes(this.interfaceComparator, interfaces));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public static Builder newInterface() {
        return new Builder();
    }

    public static Builder newInterface(GraphQLInterfaceType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private TypeResolver typeResolver;
        private InterfaceTypeDefinition definition;
        private List<InterfaceTypeExtensionDefinition> extensionDefinitions = ImmutableKit.emptyList();
        private final Map<String, GraphQLFieldDefinition> fields = new LinkedHashMap<String, GraphQLFieldDefinition>();
        private final Map<String, GraphQLNamedOutputType> interfaces = new LinkedHashMap<String, GraphQLNamedOutputType>();

        public Builder() {
        }

        public Builder(GraphQLInterfaceType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.typeResolver = existing.getTypeResolver();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.fields.putAll(FpKit.getByName(existing.getFieldDefinitions(), GraphQLFieldDefinition::getName));
            this.interfaces.putAll(FpKit.getByName(existing.originalInterfaces, GraphQLNamedSchemaElement::getName));
            this.copyExistingDirectives(existing);
        }

        public Builder definition(InterfaceTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<InterfaceTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder field(GraphQLFieldDefinition fieldDefinition) {
            Assert.assertNotNull(fieldDefinition, () -> "fieldDefinition can't be null");
            this.fields.put(fieldDefinition.getName(), fieldDefinition);
            return this;
        }

        public Builder field(UnaryOperator<GraphQLFieldDefinition.Builder> builderFunction) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction can't be null");
            GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
            builder = (GraphQLFieldDefinition.Builder)builderFunction.apply(builder);
            return this.field(builder);
        }

        public Builder field(GraphQLFieldDefinition.Builder builder) {
            return this.field(builder.build());
        }

        public Builder fields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public Builder replaceFields(List<GraphQLFieldDefinition> fieldDefinitions) {
            Assert.assertNotNull(fieldDefinitions, () -> "fieldDefinitions can't be null");
            this.fields.clear();
            fieldDefinitions.forEach(this::field);
            return this;
        }

        public boolean hasField(String fieldName) {
            return this.fields.containsKey(fieldName);
        }

        public Builder clearFields() {
            this.fields.clear();
            return this;
        }

        @Deprecated
        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder replaceInterfaces(List<GraphQLInterfaceType> interfaces) {
            return this.replaceInterfacesOrReferences(interfaces);
        }

        public Builder replaceInterfacesOrReferences(List<? extends GraphQLNamedOutputType> interfacesOrReferences) {
            Assert.assertNotNull(interfacesOrReferences, () -> "interfaces can't be null");
            this.interfaces.clear();
            for (GraphQLNamedOutputType graphQLNamedOutputType : interfacesOrReferences) {
                if (graphQLNamedOutputType instanceof GraphQLInterfaceType || graphQLNamedOutputType instanceof GraphQLTypeReference) {
                    this.interfaces.put(graphQLNamedOutputType.getName(), graphQLNamedOutputType);
                    continue;
                }
                Assert.assertShouldNeverHappen("Unexpected type " + (graphQLNamedOutputType != null ? graphQLNamedOutputType.getClass() : "null"), new Object[0]);
            }
            return this;
        }

        public Builder withInterface(GraphQLInterfaceType interfaceType) {
            Assert.assertNotNull(interfaceType, () -> "interfaceType can't be null");
            this.interfaces.put(interfaceType.getName(), interfaceType);
            return this;
        }

        public Builder withInterface(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, () -> "reference can't be null");
            this.interfaces.put(reference.getName(), reference);
            return this;
        }

        public Builder withInterfaces(GraphQLInterfaceType ... interfaceType) {
            for (GraphQLInterfaceType type : interfaceType) {
                this.withInterface(type);
            }
            return this;
        }

        public Builder withInterfaces(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.withInterface(reference);
            }
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLInterfaceType build() {
            return new GraphQLInterfaceType(this.name, this.description, this.sort(this.fields, GraphQLInterfaceType.class, GraphQLFieldDefinition.class), this.typeResolver, this.sort(this.directives, GraphQLInterfaceType.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLScalarType.class, GraphQLAppliedDirective.class), this.definition, this.extensionDefinitions, FpKit.valuesToList(this.interfaces), this.getComparator(GraphQLInterfaceType.class, GraphQLInterfaceType.class));
        }
    }
}

