/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.PublicApi;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;

@PublicApi
public class QueryComplexityInfo {
    private final int complexity;
    private final InstrumentationValidationParameters instrumentationValidationParameters;
    private final InstrumentationExecuteOperationParameters instrumentationExecuteOperationParameters;

    private QueryComplexityInfo(Builder builder) {
        this.complexity = builder.complexity;
        this.instrumentationValidationParameters = builder.instrumentationValidationParameters;
        this.instrumentationExecuteOperationParameters = builder.instrumentationExecuteOperationParameters;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public InstrumentationValidationParameters getInstrumentationValidationParameters() {
        return this.instrumentationValidationParameters;
    }

    public InstrumentationExecuteOperationParameters getInstrumentationExecuteOperationParameters() {
        return this.instrumentationExecuteOperationParameters;
    }

    public String toString() {
        return "QueryComplexityInfo{complexity=" + this.complexity + '}';
    }

    public static Builder newQueryComplexityInfo() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private int complexity;
        private InstrumentationValidationParameters instrumentationValidationParameters;
        private InstrumentationExecuteOperationParameters instrumentationExecuteOperationParameters;

        private Builder() {
        }

        public Builder complexity(int complexity) {
            this.complexity = complexity;
            return this;
        }

        public Builder instrumentationValidationParameters(InstrumentationValidationParameters parameters) {
            this.instrumentationValidationParameters = parameters;
            return this;
        }

        public Builder instrumentationExecuteOperationParameters(InstrumentationExecuteOperationParameters instrumentationExecuteOperationParameters) {
            this.instrumentationExecuteOperationParameters = instrumentationExecuteOperationParameters;
            return this;
        }

        public QueryComplexityInfo build() {
            return new QueryComplexityInfo(this);
        }
    }
}

