/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.usage;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaTraverser;
import graphql.schema.usage.SchemaUsage;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;

@PublicApi
public class SchemaUsageSupport {
    public static SchemaUsage getSchemaUsage(GraphQLSchema schema) {
        Assert.assertNotNull(schema);
        final SchemaUsage.Builder builder = new SchemaUsage.Builder();
        GraphQLTypeVisitorStub visitor = new GraphQLTypeVisitorStub(){

            private BiFunction<String, Integer, Integer> incCount() {
                return (k, v) -> v == null ? 1 : v + 1;
            }

            private void recordBackReference(GraphQLNamedSchemaElement referencedElement, GraphQLSchemaElement referencingElement) {
                String typeName;
                String referencedElementName = referencedElement.getName();
                if (referencingElement instanceof GraphQLType) {
                    typeName = GraphQLTypeUtil.unwrapAll((GraphQLType)referencingElement).getName();
                    builder.elementBackReferences.computeIfAbsent(referencedElementName, k -> new HashSet()).add(typeName);
                }
                if (referencingElement instanceof GraphQLDirective) {
                    typeName = ((GraphQLDirective)referencingElement).getName();
                    builder.elementBackReferences.computeIfAbsent(referencedElementName, k -> new HashSet()).add(typeName);
                }
            }

            private void memberInterfaces(GraphQLNamedType containingType, List<GraphQLNamedOutputType> members) {
                for (GraphQLNamedOutputType member : members) {
                    builder.interfaceReferenceCount.compute(member.getName(), this.incCount());
                    builder.interfaceImplementors.computeIfAbsent(member.getName(), k -> new HashSet()).add(containingType.getName());
                    this.recordBackReference(containingType, member);
                }
            }

            @Override
            public TraversalControl visitGraphQLArgument(GraphQLArgument node, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLUnmodifiedType inputType = GraphQLTypeUtil.unwrapAll(node.getType());
                builder.argReferenceCount.compute(inputType.getName(), this.incCount());
                GraphQLSchemaElement parentElement = context.getParentNode();
                if (parentElement instanceof GraphQLFieldDefinition) {
                    parentElement = context.getParentContext().getParentNode();
                }
                this.recordBackReference(inputType, parentElement);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLUnmodifiedType fieldType = GraphQLTypeUtil.unwrapAll(node.getType());
                builder.fieldReferenceCounts.compute(fieldType.getName(), this.incCount());
                builder.outputFieldReferenceCounts.compute(fieldType.getName(), this.incCount());
                this.recordBackReference(fieldType, context.getParentNode());
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField node, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLUnmodifiedType fieldType = GraphQLTypeUtil.unwrapAll(node.getType());
                builder.fieldReferenceCounts.compute(fieldType.getName(), this.incCount());
                builder.inputFieldReferenceCounts.compute(fieldType.getName(), this.incCount());
                this.recordBackReference(fieldType, context.getParentNode());
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLDirective(GraphQLDirective directive, TraverserContext<GraphQLSchemaElement> context) {
                GraphQLSchemaElement parentElement = context.getParentNode();
                if (parentElement != null) {
                    builder.directiveReferenceCount.compute(directive.getName(), this.incCount());
                }
                if (parentElement instanceof GraphQLArgument) {
                    context = context.getParentContext();
                    parentElement = context.getParentNode();
                }
                if (parentElement instanceof GraphQLFieldDefinition) {
                    context = context.getParentContext();
                    parentElement = context.getParentNode();
                }
                if (parentElement instanceof GraphQLInputObjectField) {
                    context = context.getParentContext();
                    parentElement = context.getParentNode();
                }
                this.recordBackReference(directive, parentElement);
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLUnionType(GraphQLUnionType unionType, TraverserContext<GraphQLSchemaElement> context) {
                List<GraphQLNamedOutputType> members = unionType.getTypes();
                for (GraphQLNamedOutputType member : members) {
                    builder.unionReferenceCount.compute(member.getName(), this.incCount());
                    this.recordBackReference(unionType, member);
                }
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType interfaceType, TraverserContext<GraphQLSchemaElement> context) {
                this.memberInterfaces(interfaceType, interfaceType.getInterfaces());
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLObjectType(GraphQLObjectType objectType, TraverserContext<GraphQLSchemaElement> context) {
                this.memberInterfaces(objectType, objectType.getInterfaces());
                return TraversalControl.CONTINUE;
            }
        };
        new SchemaTraverser().depthFirstFullSchema(visitor, schema);
        return builder.build();
    }
}

