/*
 * Decompiled with CFR 0.152.
 */
package io.javarig;

import com.google.common.primitives.Primitives;
import io.javarig.RandomInstanceGenerator;
import io.javarig.TypeEnum;
import io.javarig.exception.JavaRIGInternalException;
import io.javarig.generator.TypeGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import lombok.NonNull;

public class TypeGeneratorFactory {
    public TypeGenerator getGenerator(Type type, RandomInstanceGenerator randomInstanceGenerator) {
        try {
            return this.createGeneratorInstance(type, randomInstanceGenerator);
        }
        catch (ReflectiveOperationException e) {
            throw new JavaRIGInternalException(e);
        }
    }

    private Class<?> getRawType(Type type) {
        Type rawType = type;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            rawType = parameterizedType.getRawType();
        }
        return Primitives.wrap((Class)((Class)rawType));
    }

    private TypeEnum getTypeEnumFromType(Type type) {
        Class<?> rawType = this.getRawType(type);
        return Arrays.stream(TypeEnum.values()).filter(tEnum -> tEnum.type != null && tEnum.type.equals(rawType)).findFirst().orElseGet(() -> this.getTypeEnumForUnmatchedTypes(rawType));
    }

    @NonNull
    private TypeEnum getTypeEnumForUnmatchedTypes(Class<?> type) {
        if (type.isArray()) {
            return TypeEnum.ARRAY;
        }
        if (type.isEnum()) {
            return TypeEnum.ENUM;
        }
        return TypeEnum.OBJECT;
    }

    public TypeGenerator createGeneratorInstance(Type type, RandomInstanceGenerator randomInstanceGenerator) throws ReflectiveOperationException {
        TypeEnum typeEnum = this.getTypeEnumFromType(type);
        return typeEnum.generatorClass.getConstructor(Type.class, RandomInstanceGenerator.class).newInstance(type, randomInstanceGenerator);
    }
}

