/*
 * Decompiled with CFR 0.152.
 */
package io.javarig.generator;

import io.javarig.RandomInstanceGenerator;
import io.javarig.exception.InstanceGenerationException;
import io.javarig.generator.TypeGenerator;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public class ArrayGenerator
extends TypeGenerator {
    public ArrayGenerator(Type type, RandomInstanceGenerator randomInstanceGenerator) {
        super(type, randomInstanceGenerator);
    }

    @Override
    public Object generate() throws InstanceGenerationException {
        TypeDescriptor.OfField arrayParameterType = ((Class)this.getType()).componentType();
        if (((Class)arrayParameterType).isPrimitive()) {
            return this.generatePrimitiveArray((Class<?>)arrayParameterType);
        }
        return this.generateArray((Class<?>)arrayParameterType);
    }

    private Object generatePrimitiveArray(Class<?> primitiveType) {
        Class wrapperType = ClassUtils.primitiveToWrapper(primitiveType);
        return ArrayUtils.toPrimitive((Object)this.generateArray(wrapperType));
    }

    private Object[] generateArray(Class<?> arrayParameterType) {
        List objectList = (List)this.getRandomInstanceGenerator().generate((Type)((Object)List.class), arrayParameterType);
        Object[] arrayInstance = (Object[])Array.newInstance(arrayParameterType, 0);
        arrayInstance = objectList.toArray(arrayInstance);
        return arrayInstance;
    }
}

