/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java;

import io.github.pod4dev.java.FixedApiClient;
import io.github.pod4dev.java.GenericContainer;
import io.github.pod4dev.java.ServiceBinding;
import io.github.pod4dev.java.Utils;
import io.github.pod4dev.java.exceptions.PodmanException;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.api.PodsApi;
import io.github.pod4dev.libpodj.api.SystemApi;
import io.github.pod4dev.libpodj.model.LibpodInfo;
import io.github.pod4dev.libpodj.model.PlayKubeReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.net.SocketFactory;
import okhttp3.OkHttpClient;
import okhttp3.unixdomainsockets.UnixDomainSocketFactory;

public class KubePlayer
implements GenericContainer {
    private final ApiClient api;
    private final String yamlPath;
    private final String hostname;
    private final List<ServiceBinding> servicesBindings = new ArrayList<ServiceBinding>();
    private boolean doCleanup = true;

    public KubePlayer(String yamlPath) throws PodmanException {
        this(System.getenv("PODMAN_SOCKET"), yamlPath);
    }

    public KubePlayer(String socketPath, String yamlPath) throws PodmanException {
        if (socketPath == null || socketPath.isEmpty()) {
            throw new PodmanException("Environment variable PODMAN_SOCKET is not set");
        }
        File socketFile = new File(socketPath);
        OkHttpClient httpClient = new OkHttpClient.Builder().socketFactory((SocketFactory)new UnixDomainSocketFactory(socketFile)).build();
        this.api = new FixedApiClient().setHttpClient(httpClient).setBasePath("http://localhost/v5.0.0");
        this.yamlPath = yamlPath;
        SystemApi systemApi = new SystemApi(this.api);
        LibpodInfo libpodInfo = null;
        try {
            libpodInfo = systemApi.systemInfoLibpod().execute();
        }
        catch (ApiException ex) {
            throw new PodmanException("Doesn't initialized", ex);
        }
        this.hostname = libpodInfo.getHost().getHostname();
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    @Override
    public KubePlayer withExposedService(String serviceName, int exposedPort) throws PodmanException {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        if (!this.servicesBindings.isEmpty() && this.servicesBindings.stream().anyMatch(isBindingExist)) {
            throw new PodmanException("Binging[serviceName=%s, exposedPort=%d] already exists".formatted(serviceName, exposedPort));
        }
        int mappedPort = Utils.findFreePort();
        this.servicesBindings.add(new ServiceBinding(serviceName, this.hostname, exposedPort, mappedPort));
        return this;
    }

    @Override
    public KubePlayer withCleanup(boolean doCleanup) {
        this.doCleanup = doCleanup;
        return this;
    }

    @Override
    public void start() throws PodmanException {
        PodsApi podsApi = new PodsApi(this.api);
        String yaml = null;
        try {
            yaml = Utils.readYaml(this.yamlPath);
        }
        catch (IOException e) {
            throw new PodmanException(e);
        }
        PlayKubeReport report = null;
        try {
            report = podsApi.playKubeLibpod_0().contentType("text/plain").publishPorts(this.servicesBindings.stream().map(serviceBinding -> "%d:%d".formatted(serviceBinding.getMappedPort(), serviceBinding.getExposedPort())).toList()).wait(Boolean.valueOf(this.doCleanup)).start(Boolean.valueOf(true)).request(yaml).execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
        if (report == null || report.getPods() == null || report.getPods().isEmpty()) {
            throw new PodmanException("There is no related pods");
        }
    }

    @Override
    public void stop() throws PodmanException {
        PodsApi pods = new PodsApi(this.api);
        String yaml = null;
        try {
            yaml = Utils.readYaml(this.yamlPath);
        }
        catch (IOException e) {
            throw new PodmanException(e);
        }
        try {
            pods.playKubeDownLibpod_0().force(Boolean.valueOf(true)).request(yaml).execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
    }

    @Override
    public String getMappedHost(String serviceName, int exposedPort) {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        return this.servicesBindings.stream().filter(isBindingExist).map(ServiceBinding::getMappedHost).findAny().orElse(null);
    }

    @Override
    public int getMappedPort(String serviceName, int exposedPort) throws PodmanException {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        return this.servicesBindings.stream().filter(isBindingExist).map(ServiceBinding::getMappedPort).findAny().orElseThrow(() -> new PodmanException("Here is no mapped port"));
    }
}

