/*
 * Decompiled with CFR 0.152.
 */
package io.github.robin.code.util;

import io.github.robin.code.constant.DateTimeConstant;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtil {
    public static LocalDateTime currentDateTime() {
        return LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    public static LocalDateTime parse(String dateTime) {
        if (StringUtils.isBlank((CharSequence)dateTime)) {
            return null;
        }
        return LocalDateTime.parse(dateTime, DateTimeConstant.DATE_TIME_FORMATTER);
    }

    public static String toDateTimeString(LocalDateTime localDateTime) {
        if (Objects.isNull(localDateTime)) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    @Deprecated
    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    @Deprecated
    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

