/*
 * Decompiled with CFR 0.152.
 */
package io.github.robin.code.util;

import io.github.robin.code.constant.DateTimeConstant;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class DateUtil {
    public static LocalDate toLocalDate(String localDate) {
        if (StringUtils.isBlank((CharSequence)localDate)) {
            return null;
        }
        return LocalDate.parse(localDate, DateTimeConstant.DATE_FORMATTER);
    }

    public static LocalDate getFirstDayOfMonth(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getLastDayOfMonth(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static List<LocalDate> getDaysBetween(LocalDate startDate, LocalDate endDate) {
        return IntStream.range(0, (int)ChronoUnit.DAYS.between(startDate, endDate)).mapToObj(startDate::plusDays).collect(Collectors.toList());
    }

    @Deprecated
    public static LocalDate date2LocalDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Deprecated
    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Deprecated
    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static List<Pair<LocalDate, LocalDate>> getMonthFirstLastDate(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return Collections.emptyList();
        }
        LocalDate start = startDate.withDayOfMonth(1);
        LocalDate end = endDate.withDayOfMonth(1);
        ArrayList<Pair<LocalDate, LocalDate>> pairArrayList = new ArrayList<Pair<LocalDate, LocalDate>>();
        while (!start.isAfter(end)) {
            Pair of = Pair.of((Object)start, (Object)start.with(TemporalAdjusters.lastDayOfMonth()));
            pairArrayList.add((Pair<LocalDate, LocalDate>)of);
            start = start.plusMonths(1L);
        }
        return pairArrayList;
    }

    @Generated
    private DateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

