/*
 *  Copyright (c) Ramesh Babu Prudhvi.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.github.selcukes.java;

import io.github.selcukes.core.page.Page;
import lombok.CustomLog;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@CustomLog
public class DefaultQuestionnaireFactory implements Questionnaire, Page {
    WebDriver driver;

    public DefaultQuestionnaireFactory(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public void perform(String label, String answer, WebElement container) {
        String tagName = container.getTagName();
        logger.debug(() -> "Answering Element Tag" + tagName);
        /*
         * switch (tagName) { "input": }
         */
    }

    @Override
    public WebDriver getDriver() {
        return driver;
    }
}
