/*
 *  Copyright (c) Ramesh Babu Prudhvi.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package io.github.selcukes.java;

import io.github.selcukes.commons.helper.ServiceLoaderUtils;

public class SelcukesSPI {

    private static final ThreadLocal<QuestionnaireProvider> QUESTIONNAIRE_THREAD_LOCAL = new ThreadLocal<>();

    public static QuestionnaireProvider getQuestionnaireProvider() {
        return QUESTIONNAIRE_THREAD_LOCAL.get();
    }

    public void loadServiceProviders() {
        var loader = getClass().getClassLoader();
        QUESTIONNAIRE_THREAD_LOCAL.set(ServiceLoaderUtils.loadFirst(QuestionnaireProvider.class, loader));
    }

    public void unloadServiceProviders() {
        QUESTIONNAIRE_THREAD_LOCAL.remove();
    }
}
