/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid.resourcepack.api.builder.config;

import io.github.solid.resourcepack.api.builder.config.ConfigBuilder;
import io.github.solid.resourcepack.api.builder.feature.PredicateConfig;
import io.github.solid.resourcepack.api.predicate.PredicateIncrementor;
import io.github.solid.resourcepack.api.predicate.PredicateIncrementorType;
import io.github.solid.resourcepack.material.SolidMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0011\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\u00002\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/solid/resourcepack/api/builder/config/PredicateBuilder;", "Lio/github/solid/resourcepack/api/builder/config/ConfigBuilder;", "Lio/github/solid/resourcepack/api/builder/feature/PredicateConfig;", "()V", "incrementor", "Lio/github/solid/resourcepack/api/predicate/PredicateIncrementor;", "key", "Lnet/kyori/adventure/key/Key;", "models", "", "parent", "target", "Lio/github/solid/resourcepack/material/SolidMaterial;", "textures", "", "", "build", "", "([Lnet/kyori/adventure/key/Key;)Lio/github/solid/resourcepack/api/builder/config/PredicateBuilder;", "", "", "type", "Lio/github/solid/resourcepack/api/predicate/PredicateIncrementorType;", "solid-api"})
public final class PredicateBuilder
implements ConfigBuilder<PredicateConfig> {
    @Nullable
    private SolidMaterial target;
    @NotNull
    private final Map<String, Key> textures = new LinkedHashMap();
    @Nullable
    private Key key;
    @Nullable
    private Key parent;
    private PredicateIncrementor incrementor;
    @NotNull
    private final List<Key> models = new ArrayList();

    @NotNull
    public final PredicateBuilder target(@NotNull SolidMaterial target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        return this;
    }

    @NotNull
    public final PredicateBuilder key(@NotNull Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        return this;
    }

    @NotNull
    public final PredicateBuilder textures(@NotNull Map<String, ? extends Key> textures) {
        Intrinsics.checkNotNullParameter(textures, (String)"textures");
        this.textures.putAll(textures);
        return this;
    }

    @NotNull
    public final PredicateBuilder parent(@NotNull Key parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        return this;
    }

    @NotNull
    public final PredicateBuilder type(@NotNull PredicateIncrementorType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.incrementor = new PredicateIncrementor(type.getPredicates());
        return this;
    }

    @NotNull
    public final PredicateBuilder incrementor(@NotNull PredicateIncrementor incrementor) {
        Intrinsics.checkNotNullParameter((Object)incrementor, (String)"incrementor");
        this.incrementor = incrementor;
        return this;
    }

    @NotNull
    public final PredicateBuilder models(Key ... models) {
        Intrinsics.checkNotNullParameter((Object)models, (String)"models");
        CollectionsKt.addAll((Collection)this.models, (Object[])models);
        return this;
    }

    @NotNull
    public final PredicateBuilder models(@NotNull Collection<? extends Key> models) {
        Intrinsics.checkNotNullParameter(models, (String)"models");
        this.models.addAll(models);
        return this;
    }

    @Override
    @NotNull
    public PredicateConfig build() {
        if (this.target == null) {
            Key key = this.key;
            Intrinsics.checkNotNull((Object)key);
            this.target = new SolidMaterial(key, this.parent, this.textures);
        }
        SolidMaterial solidMaterial = this.target;
        Intrinsics.checkNotNull((Object)solidMaterial);
        SolidMaterial solidMaterial2 = solidMaterial;
        List<Key> list = this.models;
        PredicateIncrementor predicateIncrementor = this.incrementor;
        if (predicateIncrementor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"incrementor");
            predicateIncrementor = null;
        }
        PredicateIncrementor predicateIncrementor2 = predicateIncrementor;
        return new PredicateConfig(list, solidMaterial2, predicateIncrementor2);
    }
}

