/*
 * Decompiled with CFR 0.152.
 */
package io.github.solid.resourcepack.api.key;

import io.github.solid.resourcepack.api.key.KeyType;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/github/solid/resourcepack/api/key/SolidKey;", "", "()V", "CUBE_ALL", "Lnet/kyori/adventure/key/Key;", "Lorg/jetbrains/annotations/NotNull;", "getCUBE_ALL", "()Lnet/kyori/adventure/key/Key;", "ITEM_GENERATED", "getITEM_GENERATED", "ITEM_HANDHELD", "getITEM_HANDHELD", "from", "material", "Lorg/bukkit/Material;", "keyType", "Lio/github/solid/resourcepack/api/key/KeyType;", "solid-api"})
public final class SolidKey {
    @NotNull
    public static final SolidKey INSTANCE = new SolidKey();
    @NotNull
    private static final Key ITEM_GENERATED;
    @NotNull
    private static final Key ITEM_HANDHELD;
    @NotNull
    private static final Key CUBE_ALL;

    private SolidKey() {
    }

    @ApiStatus.Experimental
    @NotNull
    public final Key from(@NotNull Material material) {
        KeyType keyType;
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        if (material.isBlock()) {
            keyType = KeyType.BLOCK;
        } else if (material.isItem()) {
            keyType = KeyType.ITEM;
        } else {
            throw new IllegalArgumentException("Material is not supported");
        }
        KeyType keyType2 = keyType;
        return this.from(material, keyType2);
    }

    @NotNull
    public final Key from(@NotNull Material material, @NotNull KeyType keyType) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        String string = keyType.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = material.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        Key key = Key.key((String)"minecraft", (String)(string + "/" + string2));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        return key;
    }

    @NotNull
    public final Key getITEM_GENERATED() {
        return ITEM_GENERATED;
    }

    @NotNull
    public final Key getITEM_HANDHELD() {
        return ITEM_HANDHELD;
    }

    @NotNull
    public final Key getCUBE_ALL() {
        return CUBE_ALL;
    }

    static {
        Key key = Key.key((String)"minecraft", (String)"item/generated");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        ITEM_GENERATED = key;
        Key key2 = Key.key((String)"minecraft", (String)"item/handheld");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"key(...)");
        ITEM_HANDHELD = key2;
        Key key3 = Key.key((String)"minecraft", (String)"block/cube_all");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"key(...)");
        CUBE_ALL = key3;
    }
}

