/*
 * Decompiled with CFR 0.152.
 */
package io.github.splotycode.mosaik.annotationprocessors;

import io.github.splotycode.mosaik.annotations.skippedpath.SkipPath;
import io.github.splotycode.mosaik.util.StringUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.github.splotycode.mosaik.annotations.skippedpath.SkipPath"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class SkipPathProcessor
extends AbstractProcessor {
    private static AtomicLong id = new AtomicLong(1L);
    private static Set<String> paths = ConcurrentHashMap.newKeySet();

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment environment) {
        ArrayList<String> skippedPaths = new ArrayList<String>();
        for (Element element : environment.getElementsAnnotatedWith(SkipPath.class)) {
            if (!(element instanceof TypeElement)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@SkipPath is not a TypeElement");
                return false;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[SkipPath] Found " + element.getSimpleName());
            TypeElement mainTypeElement = (TypeElement)element;
            SkipPath annotation = mainTypeElement.getAnnotation(SkipPath.class);
            skippedPaths.addAll(Arrays.asList(annotation.value()));
        }
        for (String string : new ArrayList(skippedPaths)) {
            if (paths.contains(string)) {
                skippedPaths.remove(string);
                continue;
            }
            paths.add(string);
        }
        if (!skippedPaths.isEmpty()) {
            try {
                long id = SkipPathProcessor.id.getAndIncrement();
                FileObject descriptionFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "disabled_paths_" + id + ".txt", new Element[0]);
                try (Writer writer = descriptionFile.openWriter();){
                    writer.append("# disabled_paths.txt generated with Mosaik\n");
                    writer.append(StringUtil.join(skippedPaths, obj -> obj, (String)"\n"));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to create disabled_paths.txt", ex);
            }
        }
        return true;
    }
}

