/*
 * Decompiled with CFR 0.152.
 */
package io.github.tezch.atomsql.spring;

import io.github.tezch.atomsql.AtomSql;
import io.github.tezch.atomsql.AtomSqlUtils;
import io.github.tezch.atomsql.Configure;
import io.github.tezch.atomsql.Endpoint;
import io.github.tezch.atomsql.Endpoints;
import io.github.tezch.atomsql.SimpleConfigure;
import io.github.tezch.atomsql.spring.JdbcTemplateEndpoint;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.jdbc.core.JdbcTemplate;

public class AtomSqlContextInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final Function<JdbcTemplate, Endpoint> endpointBuilder;

    public AtomSqlContextInitializer() {
        this.endpointBuilder = jdbcTemplate -> new JdbcTemplateEndpoint((JdbcTemplate)jdbcTemplate);
    }

    public AtomSqlContextInitializer(Function<JdbcTemplate, Endpoint> endpointBuilder) {
        this.endpointBuilder = Objects.requireNonNull(endpointBuilder);
    }

    public void initialize(GenericApplicationContext context) {
        List classes;
        AtomSql.initializeIfUninitialized((Configure)AtomSqlContextInitializer.configure(context));
        try {
            classes = AtomSqlUtils.loadProxyClasses();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        BeanDefinitionCustomizer customizer = bd -> {
            bd.setScope("singleton");
            bd.setLazyInit(true);
            bd.setAutowireCandidate(true);
            bd.setPrimary(true);
        };
        context.registerBean(AtomSql.class, () -> new AtomSql(this.endpoints(context)), new BeanDefinitionCustomizer[]{customizer});
        classes.forEach(c -> {
            Class casted = c;
            context.registerBean(casted, () -> ((AtomSql)context.getBean(AtomSql.class)).of(casted), new BeanDefinitionCustomizer[]{customizer});
        });
    }

    private static Configure configure(GenericApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        Boolean enableLog = (Boolean)environment.getProperty("atomsql.enable-log", Boolean.class, (Object)false);
        String logStackTracePattern = environment.getProperty("atomsql.log-stacktrace-pattern", ".+");
        Boolean ignoreNoSqlLog = (Boolean)environment.getProperty("atomsql.ignore-no-sql-log", Boolean.class, (Object)false);
        Boolean useQualifier = (Boolean)environment.getProperty("atomsql.use-qualifier", Boolean.class, (Object)false);
        String typeFactoryClass = environment.getProperty("atomsql.type-factory-class", "");
        Integer batchThreshold = (Integer)environment.getProperty("atomsql.batch-threshold", Integer.class, (Object)0);
        return new SimpleConfigure(enableLog.booleanValue(), Pattern.compile(logStackTracePattern), ignoreNoSqlLog.booleanValue(), useQualifier.booleanValue(), typeFactoryClass, batchThreshold.intValue());
    }

    private Endpoints endpoints(GenericApplicationContext context) {
        Map map = context.getBeansOfType(JdbcTemplate.class);
        JdbcTemplate primary = (JdbcTemplate)context.getBean(JdbcTemplate.class);
        if (map.size() == 1) {
            return new Endpoints(this.endpointBuilder.apply(primary));
        }
        Endpoints.Entry[] entries = (Endpoints.Entry[])map.entrySet().stream().map(e -> {
            JdbcTemplate jdbcTemplate = (JdbcTemplate)e.getValue();
            return new Endpoints.Entry((String)e.getKey(), this.endpointBuilder.apply(jdbcTemplate), jdbcTemplate == primary);
        }).toArray(Endpoints.Entry[]::new);
        return new Endpoints(entries);
    }
}

