/*
 * Decompiled with CFR 0.152.
 */
package io.github.tezch.atomsql.spring;

import io.github.tezch.atomsql.BatchPreparedStatementSetter;
import io.github.tezch.atomsql.ConnectionProxy;
import io.github.tezch.atomsql.Constants;
import io.github.tezch.atomsql.Endpoint;
import io.github.tezch.atomsql.PreparedStatementSetter;
import io.github.tezch.atomsql.RowMapper;
import io.github.tezch.atomsql.SimpleConnectionProxy;
import io.github.tezch.atomsql.SqlProxySnapshot;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcTemplateEndpoint
implements Endpoint {
    private final JdbcTemplate jdbcTemplate;

    public JdbcTemplateEndpoint(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
    }

    public int[] batchUpdate(String sql, final BatchPreparedStatementSetter bpss) {
        return this.jdbcTemplate.batchUpdate(Constants.NEW_LINE + sql, new org.springframework.jdbc.core.BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                bpss.setValues(ps, i);
            }

            public int getBatchSize() {
                return bpss.getBatchSize();
            }
        });
    }

    public <T> Stream<T> queryForStream(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper, SqlProxySnapshot snapshot) {
        return this.jdbcTemplate.queryForStream(Constants.NEW_LINE + sql, ps -> pss.setValues(ps), (rs, rowNum) -> rowMapper.mapRow(rs, rowNum));
    }

    public int update(String sql, PreparedStatementSetter pss, SqlProxySnapshot snapshot) {
        return this.jdbcTemplate.update(Constants.NEW_LINE + sql, ps -> pss.setValues(ps));
    }

    public void logSql(System.Logger logger, String originalSql, String sql, PreparedStatement ps, SqlProxySnapshot snapshot) {
        logger.log(System.Logger.Level.INFO, "sql:" + Constants.NEW_LINE + ps.toString());
    }

    public void bollowConnection(Consumer<ConnectionProxy> consumer) {
        this.jdbcTemplate.execute(con -> {
            consumer.accept((ConnectionProxy)new SimpleConnectionProxy(con));
            return null;
        });
    }
}

