/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.javacommons.collection;

import io.github.torand.javacommons.contract.Requires;
import io.github.torand.javacommons.lang.Exceptions;
import io.github.torand.javacommons.stream.StreamHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <T> List<T> asList(Iterable<T> items) {
        return StreamHelper.streamSafely(items).toList();
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... items) {
        return StreamHelper.streamSafely(items).toList();
    }

    @SafeVarargs
    public static <T> List<T> asNonEmptyList(T first, T ... others) {
        Objects.requireNonNull(first, "first can not be null");
        return Stream.concat(Stream.of(first), StreamHelper.streamSafely(others)).toList();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return Objects.isNull(collection) || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Objects.isNull(map) || map.isEmpty();
    }

    public static boolean nonEmpty(Collection<?> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static boolean nonEmpty(Map<?, ?> map) {
        return Objects.nonNull(map) && !map.isEmpty();
    }

    public static <T> List<T> concat(Iterable<T> first, Iterable<T> second) {
        return StreamHelper.concatAndStream(first, second).toList();
    }

    @SafeVarargs
    public static <T> List<T> concat(Iterable<T> first, T ... second) {
        return Stream.concat(StreamHelper.streamSafely(first), StreamHelper.streamSafely(second)).toList();
    }

    public static <T> T headOf(Iterable<T> iterable) {
        return StreamHelper.streamSafely(iterable).findFirst().orElseThrow(Exceptions.illegalArgumentException("iterable is empty", new Object[0]));
    }

    public static <T> T tailOf(Iterable<T> iterable) {
        return StreamHelper.streamSafely(iterable).reduce((first, second) -> second).orElseThrow(Exceptions.illegalArgumentException("iterable is empty", new Object[0]));
    }

    public static <T> boolean containsAny(Iterable<T> iterable, Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return StreamHelper.streamSafely(iterable).anyMatch(predicate);
    }

    public static <T> boolean containsOneOf(Iterable<T> iterable, T ... items) {
        Requires.requireNonEmpty(items, "No items specified", new Object[0]);
        return CollectionHelper.containsAny(iterable, currentValue -> Stream.of(items).anyMatch(currentValue::equals));
    }
}

