/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.javacommons.lang;

import io.github.torand.javacommons.stream.StreamHelper;
import java.util.List;
import java.util.Objects;

public final class StringHelper {
    private StringHelper() {
    }

    public static boolean nonBlank(String string) {
        return Objects.nonNull(string) && !string.isEmpty();
    }

    public static boolean isBlank(String string) {
        return Objects.isNull(string) || string.isEmpty();
    }

    public static String generate(String string, int count) {
        Objects.requireNonNull(string, "string is null");
        return string.repeat(count);
    }

    public static String generate(String string, int count, String delimiter) {
        Objects.requireNonNull(string, "string is null");
        Objects.requireNonNull(delimiter, "delimiter is null");
        StringBuilder b = new StringBuilder();
        for (int t = 0; t < count; ++t) {
            if (t != 0) {
                b.append(delimiter);
            }
            b.append(string);
        }
        return b.toString();
    }

    public static String quote(String string) {
        if (Objects.isNull(string)) {
            return null;
        }
        return "\"" + string + "\"";
    }

    public static Object quoteIfString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return StringHelper.quote(string);
        }
        return object;
    }

    public static List<String> quoteAll(List<String> strings) {
        return StreamHelper.streamSafely(strings).map(StringHelper::quote).toList();
    }

    public static String stripHead(String string, int count) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        return string.substring(count);
    }

    public static String stripTail(String string, int count) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        return string.substring(0, Math.max(0, string.length() - count));
    }

    public static String capitalize(String string) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String uncapitalize(String string) {
        if (StringHelper.isBlank(string)) {
            return string;
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }
}

